/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj;

import com.hierynomus.sshj.signature.SignatureEdDSA;
import com.hierynomus.sshj.transport.cipher.BlockCiphers;
import com.hierynomus.sshj.transport.cipher.StreamCiphers;
import com.hierynomus.sshj.transport.kex.DHGroups;
import com.hierynomus.sshj.transport.kex.ExtendedDHGroups;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.ConfigImpl;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.signature.SignatureDSA;
import net.schmizz.sshj.signature.SignatureECDSA;
import net.schmizz.sshj.signature.SignatureRSA;
import net.schmizz.sshj.transport.cipher.AES128CBC;
import net.schmizz.sshj.transport.cipher.AES128CTR;
import net.schmizz.sshj.transport.cipher.AES192CBC;
import net.schmizz.sshj.transport.cipher.AES192CTR;
import net.schmizz.sshj.transport.cipher.AES256CBC;
import net.schmizz.sshj.transport.cipher.AES256CTR;
import net.schmizz.sshj.transport.cipher.BlowfishCBC;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.cipher.TripleDESCBC;
import net.schmizz.sshj.transport.compression.NoneCompression;
import net.schmizz.sshj.transport.kex.Curve25519SHA256;
import net.schmizz.sshj.transport.kex.DHGexSHA1;
import net.schmizz.sshj.transport.kex.DHGexSHA256;
import net.schmizz.sshj.transport.kex.ECDHNistP;
import net.schmizz.sshj.transport.mac.HMACMD5;
import net.schmizz.sshj.transport.mac.HMACMD596;
import net.schmizz.sshj.transport.mac.HMACSHA1;
import net.schmizz.sshj.transport.mac.HMACSHA196;
import net.schmizz.sshj.transport.mac.HMACSHA2256;
import net.schmizz.sshj.transport.mac.HMACSHA2512;
import net.schmizz.sshj.transport.random.BouncyCastleRandom;
import net.schmizz.sshj.transport.random.JCERandom;
import net.schmizz.sshj.transport.random.SingletonRandomFactory;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS5KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PuTTYKeyFile;
import org.slf4j.Logger;

public class DefaultConfig
extends ConfigImpl {
    private Logger log;

    public DefaultConfig() {
        this.setLoggerFactory(LoggerFactory.DEFAULT);
        this.setVersion(this.readVersionFromProperties());
        boolean bouncyCastleRegistered = SecurityUtils.isBouncyCastleRegistered();
        this.initKeyExchangeFactories(bouncyCastleRegistered);
        this.initRandomFactory(bouncyCastleRegistered);
        this.initFileKeyProviderFactories(bouncyCastleRegistered);
        this.initCipherFactories();
        this.initCompressionFactories();
        this.initMACFactories();
        this.initSignatureFactories();
        this.setKeepAliveProvider(KeepAliveProvider.HEARTBEAT);
    }

    private String readVersionFromProperties() {
        try {
            Properties properties = new Properties();
            properties.load(DefaultConfig.class.getClassLoader().getResourceAsStream("sshj.properties"));
            String property = properties.getProperty("sshj.version");
            return "SSHJ_" + property.replace('-', '_');
        }
        catch (IOException e) {
            this.log.error("Could not read the sshj.properties file, returning an 'unknown' version as fallback.");
            return "SSHJ_VERSION_UNKNOWN";
        }
    }

    @Override
    public void setLoggerFactory(LoggerFactory loggerFactory) {
        super.setLoggerFactory(loggerFactory);
        this.log = loggerFactory.getLogger(this.getClass());
    }

    protected void initKeyExchangeFactories(boolean bouncyCastleRegistered) {
        if (bouncyCastleRegistered) {
            this.setKeyExchangeFactories(new Curve25519SHA256.Factory(), new DHGexSHA256.Factory(), new ECDHNistP.Factory521(), new ECDHNistP.Factory384(), new ECDHNistP.Factory256(), new DHGexSHA1.Factory(), DHGroups.Group1SHA1(), DHGroups.Group14SHA1(), DHGroups.Group14SHA256(), DHGroups.Group15SHA512(), DHGroups.Group16SHA512(), DHGroups.Group17SHA512(), DHGroups.Group18SHA512(), ExtendedDHGroups.Group14SHA256AtSSH(), ExtendedDHGroups.Group15SHA256(), ExtendedDHGroups.Group15SHA256AtSSH(), ExtendedDHGroups.Group15SHA384AtSSH(), ExtendedDHGroups.Group16SHA256(), ExtendedDHGroups.Group16SHA384AtSSH(), ExtendedDHGroups.Group16SHA512AtSSH(), ExtendedDHGroups.Group18SHA512AtSSH());
        } else {
            this.setKeyExchangeFactories(DHGroups.Group1SHA1(), new DHGexSHA1.Factory());
        }
    }

    protected void initRandomFactory(boolean bouncyCastleRegistered) {
        this.setRandomFactory(new SingletonRandomFactory(bouncyCastleRegistered ? new BouncyCastleRandom.Factory() : new JCERandom.Factory()));
    }

    protected void initFileKeyProviderFactories(boolean bouncyCastleRegistered) {
        if (bouncyCastleRegistered) {
            this.setFileKeyProviderFactories(new OpenSSHKeyV1KeyFile.Factory(), new PKCS8KeyFile.Factory(), new PKCS5KeyFile.Factory(), new OpenSSHKeyFile.Factory(), new PuTTYKeyFile.Factory());
        }
    }

    protected void initCipherFactories() {
        LinkedList<Factory.Named<Cipher>> avail = new LinkedList<Factory.Named<Cipher>>(Arrays.asList(new AES128CTR.Factory(), new AES192CTR.Factory(), new AES256CTR.Factory(), new AES128CBC.Factory(), new AES192CBC.Factory(), new AES256CBC.Factory(), new TripleDESCBC.Factory(), new BlowfishCBC.Factory(), BlockCiphers.BlowfishCTR(), BlockCiphers.Cast128CBC(), BlockCiphers.Cast128CTR(), BlockCiphers.IDEACBC(), BlockCiphers.IDEACTR(), BlockCiphers.Serpent128CBC(), BlockCiphers.Serpent128CTR(), BlockCiphers.Serpent192CBC(), BlockCiphers.Serpent192CTR(), BlockCiphers.Serpent256CBC(), BlockCiphers.Serpent256CTR(), BlockCiphers.TripleDESCTR(), BlockCiphers.Twofish128CBC(), BlockCiphers.Twofish128CTR(), BlockCiphers.Twofish192CBC(), BlockCiphers.Twofish192CTR(), BlockCiphers.Twofish256CBC(), BlockCiphers.Twofish256CTR(), BlockCiphers.TwofishCBC(), StreamCiphers.Arcfour(), StreamCiphers.Arcfour128(), StreamCiphers.Arcfour256()));
        boolean warn = false;
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            Factory.Named f = (Factory.Named)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (Exception e) {
                warn = true;
                this.log.warn(e.getCause().getMessage());
                i.remove();
            }
        }
        if (warn) {
            this.log.warn("Disabling high-strength ciphers: cipher strengths apparently limited by JCE policy");
        }
        this.setCipherFactories(avail);
        this.log.debug("Available cipher factories: {}", (Object)avail);
    }

    protected void initSignatureFactories() {
        this.setSignatureFactories(new SignatureECDSA.Factory(), new SignatureRSA.Factory(), new SignatureDSA.Factory(), new SignatureEdDSA.Factory());
    }

    protected void initMACFactories() {
        this.setMACFactories(new HMACSHA1.Factory(), new HMACSHA196.Factory(), new HMACMD5.Factory(), new HMACMD596.Factory(), new HMACSHA2256.Factory(), new HMACSHA2512.Factory());
    }

    protected void initCompressionFactories() {
        this.setCompressionFactories(new NoneCompression.Factory());
    }
}

