/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.client.structures.B2UploadProgress;
import com.backblaze.b2.client.structures.B2UploadState;
import com.backblaze.b2.util.B2ByteProgressListener;

class B2UploadProgressAdapter
implements B2ByteProgressListener {
    private final B2UploadListener uploadListener;
    private final int partIndex;
    private final int partCount;
    private final long startByte;
    private final long length;

    B2UploadProgressAdapter(B2UploadListener uploadListener, int partIndex, int partCount, long startByte, long length) {
        this.uploadListener = uploadListener;
        this.partIndex = partIndex;
        this.partCount = partCount;
        this.startByte = startByte;
        this.length = length;
    }

    @Override
    public void progress(long nBytesSoFar) {
        B2UploadProgress progress = new B2UploadProgress(this.partIndex, this.partCount, this.startByte, this.length, nBytesSoFar, B2UploadState.UPLOADING);
        this.uploadListener.progress(progress);
    }

    @Override
    public void hitException(Exception e, long nBytesSoFar) {
        B2UploadProgress progress = new B2UploadProgress(this.partIndex, this.partCount, this.startByte, this.length, nBytesSoFar, B2UploadState.FAILED);
        this.uploadListener.progress(progress);
    }

    @Override
    public void reachedEof(long nBytesSoFar) {
        B2UploadProgress progress = new B2UploadProgress(this.partIndex, this.partCount, this.startByte, this.length, nBytesSoFar, B2UploadState.UPLOADING);
        this.uploadListener.progress(progress);
    }
}

