/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonFloatHandler
implements B2JsonTypeHandler<Float> {
    private final boolean isPrimitive;

    public B2JsonFloatHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Float.class;
    }

    @Override
    public void serialize(Float obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(obj.toString());
    }

    @Override
    public Float deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readNumberAsString();
        return this.deserializeUrlParam(str);
    }

    @Override
    public Float deserializeUrlParam(String urlValue) throws B2JsonException {
        try {
            return Float.valueOf(urlValue);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad float: " + urlValue);
        }
    }

    @Override
    public Float defaultValueForOptional() {
        if (this.isPrimitive) {
            return Float.valueOf(0.0f);
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

