/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependencies.collect.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.shared.dependencies.collect.CollectorResult;
import org.apache.maven.shared.dependencies.collect.internal.Maven30ArtifactRepositoryAdapter;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.RemoteRepository;

public class Maven30CollectorResult
implements CollectorResult {
    private final CollectResult collectResult;

    public Maven30CollectorResult(CollectResult collectResult) {
        this.collectResult = collectResult;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        final HashSet aetherRepositories = new HashSet();
        DependencyVisitor visitor = new DependencyVisitor(){

            @Override
            public boolean visitEnter(DependencyNode node) {
                aetherRepositories.addAll(node.getRepositories());
                return true;
            }

            @Override
            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        };
        this.collectResult.getRoot().accept(visitor);
        ArrayList<ArtifactRepository> mavenRepositories = new ArrayList<ArtifactRepository>(aetherRepositories.size());
        for (RemoteRepository aetherRepository : aetherRepositories) {
            mavenRepositories.add(new Maven30ArtifactRepositoryAdapter(aetherRepository));
        }
        return mavenRepositories;
    }
}

