/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="get", requiresProject=false, threadSafe=true)
public class GetMojo
extends AbstractMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private DependencyResolver dependencyResolver;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    private DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="transitive", defaultValue="true")
    private boolean transitive = true;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info("Skipping plugin execution");
            return;
        }
        if (this.coordinate.getArtifactId() == null && this.artifact == null) {
            throw new MojoFailureException("You must specify an artifact, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0");
        }
        if (this.artifact != null) {
            String[] tokens = StringUtils.split(this.artifact, ":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + this.artifact);
            }
            this.coordinate.setGroupId(tokens[0]);
            this.coordinate.setArtifactId(tokens[1]);
            this.coordinate.setVersion(tokens[2]);
            if (tokens.length >= 4) {
                this.coordinate.setType(tokens[3]);
            }
            if (tokens.length == 5) {
                this.coordinate.setClassifier(tokens[4]);
            }
        }
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
        if (this.pomRemoteRepositories != null) {
            repoList.addAll(this.pomRemoteRepositories);
        }
        if (this.remoteRepositories != null) {
            List<String> repos = Arrays.asList(StringUtils.split(this.remoteRepositories, ","));
            for (String repo : repos) {
                repoList.add(this.parseRepository(repo, always));
            }
        }
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setRemoteRepositories(repoList);
            if (this.transitive) {
                this.getLog().info("Resolving " + this.coordinate + " with transitive dependencies");
                this.dependencyResolver.resolveDependencies((ProjectBuildingRequest)buildingRequest, this.coordinate, null);
            } else {
                this.getLog().info("Resolving " + this.coordinate);
                this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, this.toArtifactCoordinate(this.coordinate));
            }
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), e);
        }
        catch (DependencyResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), e);
        }
    }

    private ArtifactCoordinate toArtifactCoordinate(DependableCoordinate dependableCoordinate) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(dependableCoordinate.getType());
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId(dependableCoordinate.getGroupId());
        artifactCoordinate.setArtifactId(dependableCoordinate.getArtifactId());
        artifactCoordinate.setVersion(dependableCoordinate.getVersion());
        artifactCoordinate.setClassifier(dependableCoordinate.getClassifier());
        artifactCoordinate.setExtension(artifactHandler.getExtension());
        return artifactCoordinate;
    }

    ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException(repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty(matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return new MavenArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException(id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }

    protected boolean isSkip() {
        return this.skip;
    }

    public void setGroupId(String groupId) {
        this.coordinate.setGroupId(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.coordinate.setArtifactId(artifactId);
    }

    public void setVersion(String version) {
        this.coordinate.setVersion(version);
    }

    public void setClassifier(String classifier) {
        this.coordinate.setClassifier(classifier);
    }

    public void setPackaging(String type) {
        this.coordinate.setType(type);
    }
}

