/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class AllVerUpdateStorageUtilized {
    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = config.getProperty("deviceUUID").toString();
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
            FindIterable<Document> devices = null;
            if (StringUtils.isEmpty(deviceUUIDList)) {
                devices = deviceColl.find();
            } else {
                String[] deviceUUIDs = deviceUUIDList.split(",");
                ArrayList<String> uuids = new ArrayList<String>();
                String[] stringArray = deviceUUIDs;
                int n = deviceUUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    uuid = uuid.replace("[", "");
                    uuid = uuid.replace("]", "");
                    uuid = uuid.trim();
                    uuids.add(uuid);
                    ++n2;
                }
                System.out.println("uuids ..." + uuids);
                BasicDBObject inQuery = new BasicDBObject();
                inQuery.append("deviceUUID", new BasicDBObject("$in", uuids));
                devices = deviceColl.find(inQuery);
            }
            System.out.println("Converting device Db object to list of  device ...");
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device = new Device();
                device.setDeviceUUID(dev.getString("deviceUUID"));
                device.setDestCollection(dev.getString("destCollection"));
                devList.add(device);
            }
            System.out.println("total device size is...." + devList.size());
            for (Device device : devList) {
                FindIterable<Document> folders;
                Date date = Calendar.getInstance().getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
                String strDate = dateFormat.format(date);
                System.out.println("....STARTDEVICE......" + strDate);
                MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
                String deviceUUID = device.getDeviceUUID();
                Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", true));
                whereQuery.add(new BasicDBObject("present", true));
                andQuery.put("$and", whereQuery);
                ArrayList<Document> allFoldersList = new ArrayList<Document>();
                int skip = 0;
                System.out.println("getting folders................");
                while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                    for (Document document : folders) {
                        allFoldersList.add(document);
                    }
                    ++skip;
                }
                System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
                long allFilesSizes = 0L;
                for (Document folder : allFoldersList) {
                    String folderName = "";
                    folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
                    andQuery = new BasicDBObject();
                    whereQuery = new ArrayList();
                    whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                    whereQuery.add(new BasicDBObject("folder", false));
                    whereQuery.add(new BasicDBObject("present", true));
                    whereQuery.add(new BasicDBObject("devicePath", folderName));
                    andQuery.put("$and", whereQuery);
                    FindIterable<Document> files = bkpColl.find(andQuery);
                    for (Document document : files) {
                        long size = 0L;
                        size = document.getLong("size");
                        allFilesSizes += size;
                    }
                }
                System.out.println("Total size...................................... :" + allFilesSizes + " for deviceUUID " + deviceUUID);
                System.out.println(".... not updating size ....");
                BasicDBObject andQuery1 = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
                andQuery1.put("$and", whereQuery1);
                Document deviceBkpOverviewInfo = (Document)deviceBkpOverviewColl.find(andQuery1).first();
                System.out.println("......existing storageutilized..." + deviceBkpOverviewInfo.get("storageUtilized"));
                BasicDBObject updateFields = new BasicDBObject();
                BasicDBObject updateQuery = new BasicDBObject();
                updateFields.append("storageUtilized", allFilesSizes);
                updateQuery.append("$set", updateFields);
                date = Calendar.getInstance().getTime();
                strDate = dateFormat.format(date);
                System.out.println("....ENDDEVICE......" + strDate);
            }
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        System.out.println("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

