/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class DecoupleDevicesUtility {
    static AtomicInteger devcount = new AtomicInteger();

    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = "";
            if (config.getProperty("deviceUUID") != null) {
                deviceUUIDList = config.getProperty("deviceUUID").toString();
            }
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            MongoCollection<Document> latestdeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
            BasicDBObject andQuery = new BasicDBObject();
            ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
            BasicDBObject deviceCriteria = new BasicDBObject("isDecoupled", true);
            whereQuery.add(deviceCriteria);
            andQuery.put("$and", whereQuery);
            DistinctIterable<String> iterable = latestdeviceBkpOverviewColl.distinct("deviceUUID", andQuery, String.class);
            MongoCursor cursor = iterable.iterator();
            ArrayList<String> list = new ArrayList<String>();
            while (cursor.hasNext()) {
                String deviceUUID = (String)cursor.next();
                list.add(deviceUUID);
            }
            System.out.println(String.valueOf(deviceUUIDList) + "...devlist val ..." + list.size());
            if (!StringUtils.isEmpty(deviceUUIDList)) {
                String[] deviceUUIDs;
                System.out.println("....deviceuuuid is mentioned.... so using it .. " + deviceUUIDList);
                list = new ArrayList();
                String[] stringArray = deviceUUIDs = deviceUUIDList.split(",");
                int n = deviceUUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    uuid = uuid.replace("[", "");
                    uuid = uuid.replace("]", "");
                    uuid = uuid.trim();
                    list.add(uuid);
                    ++n2;
                }
            }
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            BasicDBObject inQuery = new BasicDBObject();
            inQuery.append("deviceUUID", new BasicDBObject("$in", list));
            FindIterable<Document> devices = deviceColl.find(inQuery);
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device2 = new Device();
                device2.setDeviceUUID(dev.getString("deviceUUID"));
                device2.setDestCollection(dev.getString("destCollection"));
                device2.setUserName(dev.getString("userName"));
                devList.add(device2);
            }
            devList.parallelStream().forEach(device -> DecoupleDevicesUtility.updateDevices(db, devList.size(), device));
            System.out.println("....completed decoupled cases....");
            DecoupleDevicesUtility.updateZeroandNegativeDevices(db, latestdeviceBkpOverviewColl);
            System.out.println(".... end of utility ...");
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void updateDevices(MongoDatabase db, long devices, Device device) {
        String deviceUUID = device.getDeviceUUID();
        long size = DecoupleDevicesUtility.getLatestVerSizeForDevice(db, deviceUUID, device.getDestCollection());
        MongoCollection<Document> latestDeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        andQuery.put("$and", whereQuery);
        latestDeviceBkpOverviewColl.deleteMany(andQuery);
        Document doc = new Document();
        doc.put("deviceUUID", (Object)deviceUUID);
        doc.put("latestVersionsSize", (Object)size);
        latestDeviceBkpOverviewColl.insertOne(doc);
        devcount.incrementAndGet();
        System.out.println(String.valueOf(device.getUserName()) + "....device to update .######################.. " + deviceUUID + "...size..." + size + "....." + devcount.get() + "/" + devices);
    }

    private static void updateZeroandNegativeDevices(MongoDatabase db, MongoCollection latestdeviceBkpOverviewColl) {
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        BasicDBObject deviceCriteria = new BasicDBObject("latestVersionsSize", new BasicDBObject("$lte", (Object)0));
        whereQuery.add(deviceCriteria);
        andQuery.put("$and", whereQuery);
        DistinctIterable<String> iterable = latestdeviceBkpOverviewColl.distinct("deviceUUID", andQuery, String.class);
        MongoCursor cursor = iterable.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (cursor.hasNext()) {
            String deviceUUID = (String)cursor.next();
            list.add(deviceUUID);
            System.out.println("...uuid..." + deviceUUID);
        }
        cursor.close();
        System.out.println("...devlist..." + list.size());
        MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
        BasicDBObject inQuery = new BasicDBObject();
        inQuery.append("deviceUUID", new BasicDBObject("$in", list));
        FindIterable<Document> devices = deviceColl.find(inQuery);
        ArrayList devList = new ArrayList();
        Device device = null;
        int i = 0;
        for (Document dev : devices) {
            device = new Device();
            device.setDeviceUUID(dev.getString("deviceUUID"));
            device.setDestCollection(dev.getString("destCollection"));
            device.setUserName(dev.getString("userName"));
            String deviceUUID = device.getDeviceUUID();
            long size = DecoupleDevicesUtility.getLatestVerSizeForDevice(db, deviceUUID, device.getDestCollection());
            MongoCollection<Document> latestDeviceBkpOverviewColl = db.getCollection("LATEST_DEVICE_BACKUP_INFO");
            andQuery = new BasicDBObject();
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            andQuery.put("$and", whereQuery);
            latestDeviceBkpOverviewColl.deleteMany(andQuery);
            Document doc = new Document();
            doc.put("deviceUUID", (Object)deviceUUID);
            doc.put("latestVersionsSize", (Object)size);
            latestDeviceBkpOverviewColl.insertOne(doc);
            System.out.println(String.valueOf(device.getUserName()) + "....device to update .######################.. " + deviceUUID + "...size..." + size + "....." + ++i + "/" + list.size());
        }
    }

    private static long getLatestVerSizeForDevice(MongoDatabase db, String deviceUUID, String destCollection) {
        MongoCollection<Document> deviceBkpOverviewColl = db.getCollection("DEVICE_BACKUP_OVERVIEW");
        Document deviceBkpOverview = (Document)deviceBkpOverviewColl.find(new BasicDBObject("deviceUUID", deviceUUID)).first();
        BasicDBObject andQuery = new BasicDBObject();
        ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
        whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
        whereQuery.add(new BasicDBObject("folder", true));
        whereQuery.add(new BasicDBObject("present", true));
        andQuery.put("$and", whereQuery);
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        boolean skip = false;
        System.out.println("getting folders..........for device ......" + deviceUUID);
        MongoCollection<Document> bkpColl = db.getCollection(destCollection);
        for (Document document : bkpColl.find(andQuery)) {
            allFoldersList.add(document);
        }
        System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
        long latestFileSizes = 0L;
        int folderCount = 0;
        for (Document folder : allFoldersList) {
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            andQuery = new BasicDBObject();
            System.out.println(String.valueOf(deviceUUID) + "... processing..." + folderName);
            whereQuery = new ArrayList();
            whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
            whereQuery.add(new BasicDBObject("devicePath", folderName));
            whereQuery.add(new BasicDBObject("present", true));
            whereQuery.add(new BasicDBObject("folder", false));
            andQuery.put("$and", whereQuery);
            FindIterable<Document> files = bkpColl.find(andQuery);
            ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
            for (Document document : files) {
                BackUpImage backUpImage = new BackUpImage();
                backUpImage.setDevicePath(document.getString("devicePath"));
                backUpImage.setFileName(document.getString("fileName"));
                backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                backUpImage.setSize(document.getLong("size"));
                allFilesList.add(backUpImage);
            }
            List<BackUpImage> list = DecoupleDevicesUtility.getFilteredBackupImageList(allFilesList);
            long folderSize = 0L;
            for (BackUpImage image : list) {
                latestFileSizes += image.getSize();
                folderSize += image.getSize();
            }
            System.out.println("... completed folders for device..." + deviceUUID + "...." + ++folderCount + "/" + allFoldersList.size());
        }
        System.out.println("Total size...................................... :" + latestFileSizes + " for deviceUUID " + deviceUUID);
        return latestFileSizes;
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

