/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.security.SecureRandom;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.ssh.SshKeyPairGenerator;
import org.jclouds.ssh.SshKeys;

@Singleton
public class RsaSshKeyPairGenerator
implements SshKeyPairGenerator {
    private final Crypto crypto;
    private final SecureRandom secureRandom;

    @Inject
    private RsaSshKeyPairGenerator(Crypto crypto, SecureRandom secureRandom) {
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.secureRandom = Preconditions.checkNotNull(secureRandom, "secureRandom");
    }

    @Override
    public Map<String, String> get() {
        return SshKeys.generate(this.crypto.rsaKeyPairGenerator(), this.secureRandom);
    }
}

