/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.SoftwareDescription;

public class VirtualDiskImageSoftware {
    private final int id;
    private final int softwareDescriptionId;
    private final SoftwareDescription softwareDescription;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return VirtualDiskImageSoftware.builder().fromVirtualDiskImageSoftware(this);
    }

    @ConstructorProperties(value={"id", "softwareDescriptionId", "softwareDescription"})
    public VirtualDiskImageSoftware(int id, int softwareDescriptionId, @Nullable SoftwareDescription softwareDescription) {
        this.id = id;
        this.softwareDescriptionId = softwareDescriptionId;
        this.softwareDescription = softwareDescription;
    }

    public int getId() {
        return this.id;
    }

    public int getSoftwareDescriptionId() {
        return this.softwareDescriptionId;
    }

    @Nullable
    public SoftwareDescription getSoftwareDescription() {
        return this.softwareDescription;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.softwareDescriptionId, this.softwareDescription);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualDiskImageSoftware that = (VirtualDiskImageSoftware)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.softwareDescriptionId, that.softwareDescriptionId) && Objects.equal(this.softwareDescription, that.softwareDescription);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("softwareDescriptionId", this.softwareDescriptionId).add("softwareDescription", this.softwareDescription).toString();
    }

    public static class Builder {
        protected int id;
        protected int softwareDescriptionId;
        protected SoftwareDescription softwareDescription;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder softwareDescriptionId(int softwareDescriptionId) {
            this.softwareDescriptionId = softwareDescriptionId;
            return this;
        }

        public Builder softwareDescription(SoftwareDescription softwareDescription) {
            this.softwareDescription = softwareDescription;
            return this;
        }

        public VirtualDiskImageSoftware build() {
            return new VirtualDiskImageSoftware(this.id, this.softwareDescriptionId, this.softwareDescription);
        }

        public Builder fromVirtualDiskImageSoftware(VirtualDiskImageSoftware in) {
            return this.id(in.getId()).softwareDescriptionId(in.getSoftwareDescriptionId()).softwareDescription(in.getSoftwareDescription());
        }
    }
}

