/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.ruby;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallRubyGems
implements Statement {
    public static final String DEFAULT_RUBYGEMS_VERSION = "1.8.10";
    private static final String RUBYGEMS_URI_TEMPLATE = "http://production.cf.rubygems.org/rubygems/rubygems-%s.tgz";
    private Optional<String> version;
    private boolean updateSystem;
    private Optional<String> updateSystemVersion;
    private boolean updateExistingGems;

    public static Builder builder() {
        return new Builder();
    }

    protected InstallRubyGems(Optional<String> version, boolean updateSystem, Optional<String> updateSystemVersion, boolean updateExistingGems) {
        this.version = Preconditions.checkNotNull(version, "version must be set");
        this.updateSystem = updateSystem;
        this.updateSystemVersion = Preconditions.checkNotNull(updateSystemVersion, "updateSystemVersion must be set");
        this.updateExistingGems = updateExistingGems;
    }

    @Override
    public String render(OsFamily family) {
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        URI rubygemsUri = URI.create(String.format(RUBYGEMS_URI_TEMPLATE, this.version.or(DEFAULT_RUBYGEMS_VERSION)));
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add(Statements.exec("if ! hash gem 2>/dev/null; then"));
        statements.add(Statements.exec("("));
        statements.add(Statements.extractTargzAndFlattenIntoDirectory(rubygemsUri, "/tmp/rubygems"));
        statements.add(Statements.exec("{cd} /tmp/rubygems"));
        statements.add(Statements.exec("ruby setup.rb --no-format-executable"));
        statements.add(Statements.exec("{rm} -fr /tmp/rubygems"));
        statements.add(Statements.exec(")"));
        statements.add(Statements.exec("fi"));
        if (this.updateSystem) {
            statements.add(this.updateSystemVersion.isPresent() ? Statements.exec("gem update --system " + this.updateSystemVersion.get()) : Statements.exec("gem update --system"));
        }
        if (this.updateExistingGems) {
            statements.add(Statements.exec("gem update --no-rdoc --no-ri"));
        }
        return new StatementList(statements.build()).render(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableSet.of();
    }

    public static class Builder {
        private Optional<String> version = Optional.absent();
        private boolean updateSystem = false;
        private Optional<String> updateSystemVersion = Optional.absent();
        private boolean updateExistingGems = false;

        public Builder version(@Nullable String version) {
            this.version = Optional.fromNullable(version);
            return this;
        }

        public Builder updateSystem(boolean updateSystem) {
            this.updateSystem = updateSystem;
            this.updateSystemVersion = Optional.absent();
            return this;
        }

        public Builder updateSystem(boolean updateSystem, @Nullable String updateSystemVersion) {
            this.updateSystem = updateSystem;
            this.updateSystemVersion = Optional.fromNullable(updateSystemVersion);
            return this;
        }

        public Builder updateExistingGems(boolean updateExistingGems) {
            this.updateExistingGems = updateExistingGems;
            return this;
        }

        public InstallRubyGems build() {
            return new InstallRubyGems(this.version, this.updateSystem, this.updateSystemVersion, this.updateExistingGems);
        }
    }
}

