/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListBucketOptions
extends BaseHttpRequestOptions
implements Cloneable {
    public static final ListBucketOptions NONE = new ListBucketOptions();

    public ListBucketOptions withPrefix(String prefix) {
        this.queryParameters.put("prefix", Preconditions.checkNotNull(prefix, "prefix"));
        return this;
    }

    public String getPrefix() {
        return this.getFirstQueryOrNull("prefix");
    }

    public ListBucketOptions afterMarker(String marker) {
        this.queryParameters.put("marker", Preconditions.checkNotNull(marker, "marker"));
        return this;
    }

    public String getMarker() {
        return this.getFirstQueryOrNull("marker");
    }

    public ListBucketOptions maxResults(int maxKeys) {
        Preconditions.checkState(maxKeys >= 0, "maxKeys must be >= 0");
        this.queryParameters.put("max-keys", Long.toString(maxKeys));
        return this;
    }

    public Integer getMaxResults() {
        String returnVal = this.getFirstQueryOrNull("max-keys");
        return returnVal != null ? Integer.valueOf(returnVal) : null;
    }

    public ListBucketOptions delimiter(String delimiter) {
        this.queryParameters.put("delimiter", Preconditions.checkNotNull(delimiter, "delimiter"));
        return this;
    }

    public String getDelimiter() {
        return this.getFirstQueryOrNull("delimiter");
    }

    public ListBucketOptions clone() {
        ListBucketOptions newOptions = new ListBucketOptions();
        newOptions.queryParameters.putAll(this.queryParameters);
        return newOptions;
    }

    public static class Builder {
        public static ListBucketOptions withPrefix(String prefix) {
            ListBucketOptions options = new ListBucketOptions();
            return options.withPrefix(prefix);
        }

        public static ListBucketOptions afterMarker(String marker) {
            ListBucketOptions options = new ListBucketOptions();
            return options.afterMarker(marker);
        }

        public static ListBucketOptions maxResults(int maxKeys) {
            ListBucketOptions options = new ListBucketOptions();
            return options.maxResults(maxKeys);
        }

        public static ListBucketOptions delimiter(String delimiter) {
            ListBucketOptions options = new ListBucketOptions();
            return options.delimiter(delimiter);
        }
    }
}

