/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.util.S3Utils;
import org.jclouds.util.Strings2;

@Singleton
public class RequestAuthorizeSignatureV2
implements RequestAuthorizeSignature,
RequestSigner {
    private static final Collection<String> FIRST_HEADERS_TO_SIGN = ImmutableList.of("Date");
    private static final Set<String> SIGNED_PARAMETERS = ImmutableSet.of("acl", "torrent", "logging", "location", "policy", "requestPayment", new String[]{"versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "response-content-type", "response-content-language", "response-expires", "response-cache-control", "response-content-disposition", "response-content-encoding", "delete"});
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final javax.inject.Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;
    private final String authTag;
    private final String headerTag;
    private final String servicePath;
    private final boolean isVhostStyle;
    private final DateService dateService;

    @Inject
    public RequestAuthorizeSignatureV2(SignatureWire signatureWire, @Named(value="jclouds.aws.auth.tag") String authTag, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath, @Named(value="jclouds.aws.header.tag") String headerTag, @Provider Supplier<Credentials> creds, @TimeStamp javax.inject.Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils, DateService dateService) {
        this.isVhostStyle = isVhostStyle;
        this.servicePath = servicePath;
        this.headerTag = headerTag;
        this.authTag = authTag;
        this.signatureWire = signatureWire;
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.utils = utils;
        this.dateService = dateService;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = this.replaceDateHeader(request);
        Credentials current = this.creds.get();
        if (current instanceof SessionCredentials) {
            request = this.replaceSecurityTokenHeader(request, (SessionCredentials)SessionCredentials.class.cast(current));
        }
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = this.replaceAuthorizationHeader(request, signature);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    HttpRequest replaceSecurityTokenHeader(HttpRequest request, SessionCredentials current) {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-amz-security-token", current.getSessionToken())).build();
    }

    protected HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", this.authTag + " " + this.creds.get().identity + ":" + signature)).build();
        return request;
    }

    HttpRequest replaceDateHeader(HttpRequest request) {
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Date", this.timeStampProvider.get())).build();
        return request;
    }

    @Override
    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        TreeMultimap<String, String> canonicalizedHeaders = TreeMultimap.create();
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, canonicalizedHeaders);
        if (canonicalizedHeaders.containsKey("x-" + this.headerTag + "-date")) {
            canonicalizedHeaders.removeAll("date");
        }
        this.appendAmzHeaders(canonicalizedHeaders, buffer);
        this.appendBucketName(request, buffer);
        this.appendUriPath(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(buffer.toString());
        }
        return buffer.toString();
    }

    String calculateSignature(String toSign) throws HttpException {
        String signature = this.sign(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream(signature));
        }
        return signature;
    }

    @Override
    public String sign(String toSign) {
        try {
            ByteProcessor<byte[]> hmacSHA1 = Macs.asByteProcessor(this.crypto.hmacSHA1(this.creds.get().credential.getBytes(Charsets.UTF_8)));
            return BaseEncoding.base64().encode(ByteStreams.readBytes(Strings2.toInputStream(toSign), hmacSHA1));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
    }

    void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    @VisibleForTesting
    void appendAmzHeaders(SortedSetMultimap<String, String> canonicalizedHeaders, StringBuilder toSign) {
        for (Map.Entry header : canonicalizedHeaders.entries()) {
            String key = (String)header.getKey();
            if (!key.startsWith("x-" + this.headerTag + "-")) continue;
            toSign.append(String.format("%s:%s\n", key.toLowerCase(), header.getValue()));
        }
    }

    void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(request.getPayload() == null ? Strings.nullToEmpty(request.getFirstHeaderOrNull("Content-MD5")) : HttpUtils.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentMD5())).append("\n");
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? request.getFirstHeaderOrNull("Content-Type") : request.getPayload().getContentMetadata().getContentType())).append("\n");
        for (String header : FIRST_HEADERS_TO_SIGN) {
            buffer.append(HttpUtils.nullToEmpty(request.getHeaders().get(header))).append("\n");
        }
    }

    @VisibleForTesting
    void appendHttpHeaders(HttpRequest request, SortedSetMultimap<String, String> canonicalizedHeaders) {
        Multimap<String, String> headers = request.getHeaders();
        for (Map.Entry<String, String> header : headers.entries()) {
            String key;
            if (header.getKey() == null || !(key = header.getKey().toString().toLowerCase(Locale.getDefault())).equalsIgnoreCase("Content-Type") && !key.equalsIgnoreCase("Content-MD5") && !key.equalsIgnoreCase("Date") && !key.startsWith("x-" + this.headerTag + "-")) continue;
            canonicalizedHeaders.put(key, header.getValue());
        }
    }

    @VisibleForTesting
    void appendBucketName(HttpRequest req, StringBuilder toSign) {
        String bucketName = S3Utils.getBucketName(req);
        if (this.isVhostStyle && bucketName != null && bucketName.equals(bucketName.toLowerCase())) {
            toSign.append(this.servicePath).append(bucketName);
        }
    }

    @VisibleForTesting
    void appendUriPath(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath());
        if (request.getEndpoint().getQuery() != null) {
            Multimap<String, String> params = Queries.queryParser().apply(request.getEndpoint().getQuery());
            int separator = 63;
            for (String paramName : Ordering.natural().sortedCopy(params.keySet())) {
                if (!SIGNED_PARAMETERS.contains(paramName)) continue;
                toSign.append((char)separator).append(paramName);
                String paramValue = Iterables.get(params.get(paramName), 0);
                if (paramValue != null) {
                    toSign.append("=").append(paramValue);
                }
                separator = 38;
            }
        }
    }

    @Override
    public HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        String dateString = request.getFirstHeaderOrNull("Date");
        if (dateString == null) {
            dateString = this.timeStampProvider.get();
        }
        Date date = this.dateService.rfc1123DateParse(dateString);
        String expiration = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(date.getTime()) + timeInSeconds);
        HttpRequest.Builder builder = (HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).replaceHeader("Date", expiration);
        String stringToSign = this.createStringToSign(builder.build());
        String signature = this.sign(stringToSign);
        HttpRequest ret = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)((HttpRequest.Builder)builder.addQueryParam("Expires", expiration)).addQueryParam("AWSAccessKeyId", this.creds.get().identity)).addQueryParam("Signature", signature)).removeHeader("Date")).filters(ImmutableList.of())).build();
        return ret;
    }
}

