/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.options.PutObjectOptions;

@Singleton
public class S3BlobRequestSigner<T extends S3Client>
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private final RequestAuthorizeSignature authSigner;
    protected final RestAnnotationProcessor processor;
    protected final BlobToObject blobToObject;
    protected final BlobToHttpGetOptions blob2HttpGetOptions;
    protected final Invokable<?, ?> getMethod;
    protected final Invokable<?, ?> deleteMethod;
    protected final Invokable<?, ?> createMethod;

    @Inject
    public S3BlobRequestSigner(RestAnnotationProcessor processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Class<T> interfaceClass, RequestAuthorizeSignature authSigner) throws SecurityException, NoSuchMethodException {
        this.processor = Preconditions.checkNotNull(processor, "processor");
        this.blobToObject = Preconditions.checkNotNull(blobToObject, "blobToObject");
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.getMethod = Reflection2.method(interfaceClass, "getObject", String.class, String.class, GetOptions[].class);
        this.deleteMethod = Reflection2.method(interfaceClass, "deleteObject", String.class, String.class);
        this.createMethod = Reflection2.method(interfaceClass, "putObject", String.class, S3Object.class, PutObjectOptions[].class);
        this.authSigner = authSigner;
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(container, name)));
        return BlobStoreUtils.cleanRequest(this.authSigner.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, 900L);
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(blob, "blob");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create(this.createMethod, ImmutableList.of(container, this.blobToObject.apply(blob))));
        return BlobStoreUtils.cleanRequest(this.authSigner.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(container, name, this.blob2HttpGetOptions.apply(Preconditions.checkNotNull(options, "options"))))));
    }
}

