/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.loadbalancer.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;

@Singleton
public class CloudLoadBalancersGetLoadBalancerMetadataStrategy
implements GetLoadBalancerMetadataStrategy {
    private final CloudLoadBalancersApi client;
    private final Function<LoadBalancer, LoadBalancerMetadata> converter;

    @Inject
    protected CloudLoadBalancersGetLoadBalancerMetadataStrategy(CloudLoadBalancersApi client, Function<LoadBalancer, LoadBalancerMetadata> converter) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.converter = Preconditions.checkNotNull(converter, "converter");
    }

    @Override
    public LoadBalancerMetadata getLoadBalancer(String id) {
        String[] parts = Preconditions.checkNotNull(id, "id").split("/");
        String region = parts[0];
        int lbId = Integer.parseInt(parts[1]);
        return this.converter.apply(this.client.getLoadBalancerApi(region).get(lbId));
    }
}

