/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class VirtualIP {
    private final Type type;
    private final IPVersion ipVersion;

    public static VirtualIP publicIPv6() {
        return new VirtualIP(Type.PUBLIC, IPVersion.IPV6);
    }

    protected VirtualIP(Type type, IPVersion ipVersion) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.ipVersion = Preconditions.checkNotNull(ipVersion, "ipVersion");
    }

    public Type getType() {
        return this.type;
    }

    public IPVersion getIpVersion() {
        return this.ipVersion;
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("ipVersion", (Object)this.ipVersion).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.ipVersion, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualIP that = (VirtualIP)VirtualIP.class.cast(obj);
        return Objects.equal((Object)this.ipVersion, (Object)that.ipVersion) && Objects.equal((Object)this.type, (Object)that.type);
    }

    public static enum IPVersion {
        IPV4,
        IPV6,
        UNRECOGNIZED;


        public static IPVersion fromValue(String ipVersion) {
            try {
                return IPVersion.valueOf(Preconditions.checkNotNull(ipVersion, "ipVersion"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PUBLIC,
        SERVICENET,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf(Preconditions.checkNotNull(type, "type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

