/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.ovf.ProductSection;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.VirtualHardwareSection;

public class BaseVirtualSystem<T extends BaseVirtualSystem<T>>
extends Section<T> {
    protected final String id;
    protected final String name;
    protected final OperatingSystemSection operatingSystem;
    protected final Set<? extends VirtualHardwareSection> virtualHardwareSections;
    protected final Set<? extends ProductSection> productSections;
    protected final Multimap<String, Section> additionalSections;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder<T> toBuilder() {
        return new Builder().fromVirtualSystem(this);
    }

    public BaseVirtualSystem(String id, String info, String name, OperatingSystemSection operatingSystem, Iterable<? extends VirtualHardwareSection> virtualHardwareSections, Iterable<? extends ProductSection> productSections, Multimap<String, Section> additionalSections) {
        super(info);
        this.id = id;
        this.name = name;
        this.operatingSystem = Preconditions.checkNotNull(operatingSystem, "operatingSystem");
        this.virtualHardwareSections = ImmutableSet.copyOf(Preconditions.checkNotNull(virtualHardwareSections, "virtualHardwareSections"));
        this.productSections = ImmutableSet.copyOf(Preconditions.checkNotNull(productSections, "productSections"));
        this.additionalSections = ImmutableMultimap.copyOf(Preconditions.checkNotNull(additionalSections, "additionalSections"));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public OperatingSystemSection getOperatingSystemSection() {
        return this.operatingSystem;
    }

    public Set<? extends VirtualHardwareSection> getVirtualHardwareSections() {
        return this.virtualHardwareSections;
    }

    public Set<? extends ProductSection> getProductSections() {
        return this.productSections;
    }

    public Multimap<String, Section> getAdditionalSections() {
        return this.additionalSections;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseVirtualSystem other = (BaseVirtualSystem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public String toString() {
        return String.format("[id=%s, name=%s, info=%s, operatingSystem=%s, virtualHardwareSections=%s,  productSections=%s, additionalSections=%s]", this.id, this.name, this.info, this.operatingSystem, this.virtualHardwareSections, this.productSections, this.additionalSections);
    }

    public static class Builder<T extends BaseVirtualSystem<T>>
    extends Section.Builder<T> {
        protected String id;
        protected String name;
        protected OperatingSystemSection operatingSystem;
        protected Set<VirtualHardwareSection> virtualHardwareSections = Sets.newLinkedHashSet();
        protected Set<ProductSection> productSections = Sets.newLinkedHashSet();
        protected Multimap<String, Section> additionalSections = LinkedHashMultimap.create();

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> operatingSystemSection(OperatingSystemSection operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder<T> virtualHardwareSection(VirtualHardwareSection virtualHardwareSection) {
            this.virtualHardwareSections.add(Preconditions.checkNotNull(virtualHardwareSection, "virtualHardwareSection"));
            return this;
        }

        public Builder<T> virtualHardwareSections(Iterable<? extends VirtualHardwareSection> virtualHardwareSections) {
            this.virtualHardwareSections = ImmutableSet.copyOf(Preconditions.checkNotNull(virtualHardwareSections, "virtualHardwareSections"));
            return this;
        }

        public Builder<T> productSection(ProductSection productSection) {
            this.productSections.add(Preconditions.checkNotNull(productSection, "productSection"));
            return this;
        }

        public Builder<T> productSections(Iterable<? extends ProductSection> productSections) {
            this.productSections = ImmutableSet.copyOf(Preconditions.checkNotNull(productSections, "productSections"));
            return this;
        }

        public Builder<T> additionalSection(String name, Section additionalSection) {
            this.additionalSections.put(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(additionalSection, "additionalSection"));
            return this;
        }

        public Builder<T> additionalSections(Multimap<String, Section> additionalSections) {
            this.additionalSections = ImmutableMultimap.copyOf(Preconditions.checkNotNull(additionalSections, "additionalSections"));
            return this;
        }

        @Override
        public BaseVirtualSystem<T> build() {
            return new BaseVirtualSystem(this.id, this.info, this.name, this.operatingSystem, this.virtualHardwareSections, this.productSections, this.additionalSections);
        }

        public Builder<T> fromVirtualSystem(BaseVirtualSystem<T> in) {
            return ((Builder)this.fromSection((Section)in)).id(in.getId()).name(in.getName()).operatingSystemSection(in.getOperatingSystemSection()).virtualHardwareSections(in.getVirtualHardwareSections()).productSections(in.getProductSections()).additionalSections(in.getAdditionalSections());
        }

        @Override
        public Builder<T> fromSection(Section<T> in) {
            return (Builder)super.fromSection(in);
        }

        @Override
        public Builder<T> info(String info) {
            return (Builder)super.info(info);
        }
    }
}

