/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.handlers;

import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class TroveErrorHandler
implements HttpErrorHandler {
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        byte[] data = HttpUtils.closeClientButKeepContentStream(response);
        String message = data != null ? new String(data) : null;
        RuntimeException exception = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
        switch (response.getStatusCode()) {
            case 400: {
                if (!message.contains("quota exceeded")) break;
                exception = new InsufficientResourcesException(message, exception);
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, exception);
                break;
            }
            case 413: {
                exception = new InsufficientResourcesException(message, exception);
            }
        }
        command.setException(exception);
    }
}

