/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.openstack.trove.v1.domain.Flavor;
import org.jclouds.openstack.trove.v1.internal.Volume;
import org.jclouds.openstack.v2_0.domain.Link;

public class Instance
implements Comparable<Instance> {
    private final String id;
    private final String name;
    private final Flavor flavor;
    private final Volume volume;
    private final Status status;
    private final List<Link> links;
    private final String hostname;

    @ConstructorProperties(value={"id", "name", "flavor", "volume", "status", "links", "hostname"})
    protected Instance(String id, String name, Flavor flavor, Volume volume, Status status, List<Link> links, String hostname) {
        this.id = Preconditions.checkNotNull(id, "id required");
        this.name = Preconditions.checkNotNull(name, "name required");
        this.flavor = Preconditions.checkNotNull(flavor, "flavor required");
        this.volume = Preconditions.checkNotNull(volume, "volume required");
        Preconditions.checkArgument(volume.getSize() > 0, "Size must be greater than 0");
        this.status = Preconditions.checkNotNull(status, "status required");
        this.links = Preconditions.checkNotNull(links, "links required");
        this.hostname = hostname;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Flavor getFlavor() {
        return this.flavor;
    }

    public int getSize() {
        return this.volume.getSize();
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.id, this.name, this.volume.getSize(), this.flavor, this.status, this.links, this.hostname});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Instance that = (Instance)Instance.class.cast(obj);
        return Objects.equal(this.id, that.id);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("flavor", this.flavor).add("volume size", this.volume.getSize()).add("links", this.links).add("hostname", this.hostname);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromInstance(this);
    }

    @Override
    public int compareTo(Instance that) {
        return this.getId().compareTo(that.getId());
    }

    public static class Builder {
        protected String id;
        protected String name;
        protected int size;
        protected Flavor flavor;
        protected Status status;
        protected ImmutableList<Link> links;
        protected String hostname;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder flavor(Flavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder links(ImmutableList<Link> links) {
            this.links = links;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Instance build() {
            return new Instance(this.id, this.name, this.flavor, new Volume(this.size), this.status, this.links, this.hostname);
        }

        public Builder fromInstance(Instance in) {
            return this.id(in.getId()).name(in.getName()).flavor(in.getFlavor()).size(in.getSize()).status(in.getStatus()).links(this.links).hostname(this.hostname);
        }
    }

    public static enum Status {
        BUILD,
        REBOOT,
        ACTIVE,
        BLOCKED,
        RESIZE,
        SHUTDOWN,
        UNRECOGNIZED;


        public String value() {
            return this.name();
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Preconditions.checkNotNull(status, "type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

