/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.parsers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.openstack.keystone.v3.domain.Token;

@Singleton
public class ParseTokenFromHttpResponse
implements Function<HttpResponse, Token> {
    private final ParseFirstJsonValueNamed<Token> parser;

    @Inject
    ParseTokenFromHttpResponse(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed<Token>(gsonView, TypeLiteral.get(Token.class), "token");
    }

    @Override
    public Token apply(HttpResponse response) {
        Preconditions.checkNotNull(response, "response");
        Token toParse = this.parser.apply(response);
        Preconditions.checkNotNull(toParse, "parsed result from %s", response);
        String xSubjectToken = response.getFirstHeaderOrNull("X-Subject-Token");
        return toParse.toBuilder().id(xSubjectToken).build();
    }
}

