/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserGroupsToIndexedFormParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Iterable, "this binder is only valid for Iterable<?>: " + input.getClass());
        this.checkValidUserGroup(input);
        return AWSUtils.indexIterableToFormValuesWithPrefix(request, "UserGroup", input);
    }

    private void checkValidUserGroup(Object input) {
        Iterable values = (Iterable)input;
        long size = Iterables.size(values);
        Preconditions.checkArgument(size == 0L || size == 1L && Iterables.getOnlyElement(values).equals("all"), "only supported UserGroup is 'all'");
    }
}

