/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.digitalocean2.domain.Networks;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Singleton
public class DropletToNodeMetadata
implements Function<Droplet, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Supplier<Map<String, ? extends org.jclouds.compute.domain.Image>> images;
    private final Supplier<Map<String, ? extends Hardware>> hardwares;
    private final Supplier<Set<? extends Location>> locations;
    private final Function<Droplet.Status, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention groupNamingConvention;
    private final Map<String, Credentials> credentialStore;

    @Inject
    DropletToNodeMetadata(Supplier<Map<String, ? extends org.jclouds.compute.domain.Image>> images, Supplier<Map<String, ? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations, Function<Droplet.Status, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory groupNamingConvention, Map<String, Credentials> credentialStore) {
        this.images = Preconditions.checkNotNull(images, "images cannot be null");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares cannot be null");
        this.locations = Preconditions.checkNotNull(locations, "locations cannot be null");
        this.toPortableStatus = Preconditions.checkNotNull(toPortableStatus, "toPortableStatus cannot be null");
        this.groupNamingConvention = Preconditions.checkNotNull(groupNamingConvention, "groupNamingConvention cannot be null").createWithoutPrefix();
        this.credentialStore = Preconditions.checkNotNull(credentialStore, "credentialStore cannot be null");
    }

    @Override
    public NodeMetadata apply(Droplet input) {
        Credentials credentials;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(String.valueOf(input.id()));
        builder.name(input.name());
        builder.hostname(input.name());
        builder.group(this.groupNamingConvention.extractGroup(input.name()));
        builder.hardware(this.getHardware(input.sizeSlug()));
        builder.location(this.getLocation(input.region()));
        Optional<? extends org.jclouds.compute.domain.Image> image = this.findImage(input.image(), input.region().slug());
        if (image.isPresent()) {
            builder.imageId(image.get().getId());
            builder.operatingSystem(image.get().getOperatingSystem());
        } else {
            this.logger.info(">> image with id %s for droplet %s was not found. This might be because the image that was used to create the droplet has a new id.", input.image().id(), input.id());
        }
        builder.status(this.toPortableStatus.apply(input.status()));
        builder.backendStatus(input.status().name());
        if (!input.getPublicAddresses().isEmpty()) {
            builder.publicAddresses(FluentIterable.from(input.getPublicAddresses()).transform(new Function<Networks.Address, String>(){

                @Override
                public String apply(Networks.Address input) {
                    return input.ip();
                }
            }));
        }
        if (!input.getPrivateAddresses().isEmpty()) {
            builder.privateAddresses(FluentIterable.from(input.getPrivateAddresses()).transform(new Function<Networks.Address, String>(){

                @Override
                public String apply(Networks.Address input) {
                    return input.ip();
                }
            }));
        }
        if ((credentials = this.credentialStore.get("node#" + input.id())) instanceof LoginCredentials) {
            builder.credentials((LoginCredentials)LoginCredentials.class.cast(credentials));
        }
        return builder.build();
    }

    protected Optional<? extends org.jclouds.compute.domain.Image> findImage(Image image, String region) {
        return Optional.fromNullable(this.images.get().get(ImageInRegion.encodeId(ImageInRegion.create(image, region))));
    }

    protected Hardware getHardware(final String slug) {
        return Iterables.find(this.hardwares.get().values(), new Predicate<Hardware>(){

            @Override
            public boolean apply(Hardware input) {
                return input.getId().equals(slug);
            }
        });
    }

    protected Location getLocation(final Region region) {
        return Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

            @Override
            public boolean apply(Location location) {
                return region != null && region.slug().equals(location.getId());
            }
        }, null);
    }
}

