/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.BootstrapConfig;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.json.Json;

@Singleton
public class BootstrapConfigForGroup
implements Function<String, BootstrapConfig> {
    private final ChefApi api;
    private final String databag;
    private final Json json;

    @Inject
    BootstrapConfigForGroup(@Named(value="chef.bootstrap-databag") String databag, ChefApi api, Json json) {
        this.databag = databag;
        this.api = api;
        this.json = json;
    }

    @Override
    public BootstrapConfig apply(String from) {
        DatabagItem bootstrapConfig = this.api.getDatabagItem(this.databag, from);
        Preconditions.checkState(bootstrapConfig != null, "databag item %s/%s not found", this.databag, from);
        return this.json.fromJson(bootstrapConfig.toString(), BootstrapConfig.class);
    }
}

