/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Secret;
import org.jclouds.azurecompute.arm.domain.AutoValue_Secret_DeletedSecretBundle;
import org.jclouds.azurecompute.arm.domain.AutoValue_Secret_SecretAttributes;
import org.jclouds.azurecompute.arm.domain.AutoValue_Secret_SecretBundle;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Secret {
    @Nullable
    public abstract SecretAttributes attributes();

    @Nullable
    public abstract String contentType();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract Boolean managed();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"attributes", "contentType", "id", "managed", "tags"})
    public static Secret create(SecretAttributes attributes, String contentType, String id, Boolean managed, Map<String, String> tags) {
        return new AutoValue_Secret(attributes, contentType, id, managed, tags != null ? ImmutableMap.copyOf(tags) : null);
    }

    Secret() {
    }

    public static abstract class SecretBundle {
        @Nullable
        public abstract SecretAttributes attributes();

        @Nullable
        public abstract String contentType();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String kid();

        @Nullable
        public abstract Boolean managed();

        @Nullable
        public abstract Map<String, String> tags();

        @Nullable
        public abstract String value();

        @SerializedNames(value={"attributes", "contentType", "id", "kid", "managed", "tags", "value"})
        public static SecretBundle create(SecretAttributes attributes, String contentType, String id, String kid, Boolean managed, Map<String, String> tags, String value) {
            return new AutoValue_Secret_SecretBundle(attributes, contentType, id, kid, managed, tags != null ? ImmutableMap.copyOf(tags) : null, value);
        }
    }

    public static abstract class DeletedSecretBundle {
        @Nullable
        public abstract SecretAttributes attributes();

        @Nullable
        public abstract String contentType();

        @Nullable
        public abstract String deletedDate();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String kid();

        @Nullable
        public abstract Boolean managed();

        @Nullable
        public abstract String recoveryId();

        @Nullable
        public abstract String scheduledPurgeDate();

        @Nullable
        public abstract Map<String, String> tags();

        @Nullable
        public abstract String value();

        @SerializedNames(value={"attributes", "contentType", "deletedDate", "id", "kid", "managed", "recoveryId", "scheduledPurgeDate", "tags", "value"})
        public static DeletedSecretBundle create(SecretAttributes attributes, String contentType, String deletedDate, String id, String kid, Boolean managed, String recoveryId, String scheduledPurgeDate, Map<String, String> tags, String value) {
            return new AutoValue_Secret_DeletedSecretBundle(attributes, contentType, deletedDate, id, kid, managed, recoveryId, scheduledPurgeDate, tags != null ? ImmutableMap.copyOf(tags) : null, value);
        }
    }

    public static abstract class SecretAttributes {
        @Nullable
        public abstract Boolean enabled();

        @Nullable
        public abstract Integer created();

        @Nullable
        public abstract Integer expires();

        @Nullable
        public abstract Integer notBefore();

        @Nullable
        public abstract String recoveryLevel();

        @Nullable
        public abstract Integer updated();

        @SerializedNames(value={"enabled", "created", "expires", "notBefore", "recoveryLevel", "updated"})
        public static SecretAttributes create(Boolean enabled, Integer created, Integer expires, Integer notBefore, String recoveryLevel, Integer updated) {
            return new AutoValue_Secret_SecretAttributes(enabled, created, expires, notBefore, recoveryLevel, updated);
        }

        SecretAttributes() {
        }
    }
}

