/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.aws.ec2.options.Tenancy;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.scriptbuilder.domain.Statement;

public class AWSEC2TemplateOptions
extends EC2TemplateOptions
implements Cloneable {
    private boolean monitoringEnabled;
    private String placementGroup = null;
    private boolean noPlacementGroup;
    private String subnetId;
    private Float spotPrice;
    private RequestSpotInstancesOptions spotOptions = RequestSpotInstancesOptions.NONE;
    private Set<String> groupIds = ImmutableSet.of();
    private String iamInstanceProfileArn;
    private String iamInstanceProfileName;
    private String privateIpAddress;
    private Tenancy tenancy;
    private String dedicatedHostId;
    public static final AWSEC2TemplateOptions NONE = new AWSEC2TemplateOptions();

    @Override
    public AWSEC2TemplateOptions clone() {
        AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
        this.copyTo(options);
        return options;
    }

    @Override
    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof AWSEC2TemplateOptions) {
            AWSEC2TemplateOptions eTo = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(to);
            if (this.getSubnetId() != null) {
                eTo.subnetId(this.getSubnetId());
            }
            if (this.getIAMInstanceProfileArn() != null) {
                eTo.iamInstanceProfileArn(this.getIAMInstanceProfileArn());
            }
            if (this.getIAMInstanceProfileName() != null) {
                eTo.iamInstanceProfileName(this.getIAMInstanceProfileName());
            }
            if (this.isMonitoringEnabled()) {
                eTo.enableMonitoring();
            }
            if (!this.shouldAutomaticallyCreatePlacementGroup()) {
                eTo.noPlacementGroup();
            }
            if (this.getPlacementGroup() != null) {
                eTo.placementGroup(this.getPlacementGroup());
            }
            if (!this.getGroupIds().isEmpty()) {
                eTo.securityGroupIds(this.getGroupIds());
            }
            if (this.getSpotPrice() != null) {
                eTo.spotPrice(this.getSpotPrice());
            }
            if (this.getSpotOptions() != null) {
                eTo.spotOptions(this.getSpotOptions());
            }
            if (this.getPrivateIpAddress() != null) {
                eTo.privateIpAddress(this.getPrivateIpAddress());
            }
            if (this.getTenancy() != null) {
                eTo.tenancy(this.getTenancy());
            }
            if (this.getDedicatedHostId() != null) {
                eTo.dedicatedHostId(this.getDedicatedHostId());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSEC2TemplateOptions that = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(o);
        return super.equals(that) && Objects.equal(this.monitoringEnabled, that.monitoringEnabled) && Objects.equal(this.placementGroup, that.placementGroup) && Objects.equal(this.noPlacementGroup, that.noPlacementGroup) && Objects.equal(this.subnetId, that.subnetId) && Objects.equal(this.spotPrice, that.spotPrice) && Objects.equal(this.spotOptions, that.spotOptions) && Objects.equal(this.groupIds, that.groupIds) && Objects.equal(this.iamInstanceProfileArn, that.iamInstanceProfileArn) && Objects.equal(this.iamInstanceProfileName, that.iamInstanceProfileName) && Objects.equal(this.privateIpAddress, that.privateIpAddress) && Objects.equal((Object)this.tenancy, (Object)that.tenancy) && Objects.equal(this.dedicatedHostId, that.dedicatedHostId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(new Object[]{super.hashCode(), this.monitoringEnabled, this.placementGroup, this.noPlacementGroup, this.subnetId, this.spotPrice, this.spotOptions, this.groupIds, this.iamInstanceProfileArn, this.iamInstanceProfileName, this.privateIpAddress, this.tenancy, this.dedicatedHostId});
    }

    @Override
    public MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = super.string();
        if (this.monitoringEnabled) {
            toString.add("monitoringEnabled", this.monitoringEnabled);
        }
        toString.add("placementGroup", this.placementGroup);
        if (this.noPlacementGroup) {
            toString.add("noPlacementGroup", this.noPlacementGroup);
        }
        toString.add("subnetId", this.subnetId);
        toString.add("spotPrice", this.spotPrice);
        if (this.spotOptions != RequestSpotInstancesOptions.NONE) {
            toString.add("spotOptions", this.spotOptions);
        }
        if (!this.groupIds.isEmpty()) {
            toString.add("groupIds", this.groupIds);
        }
        toString.add("iamInstanceProfileArn", this.iamInstanceProfileArn);
        toString.add("iamInstanceProfileName", this.iamInstanceProfileName);
        toString.add("privateIpAddress", this.privateIpAddress);
        toString.add("tenancy", (Object)this.tenancy);
        toString.add("dedicatedHostId", this.dedicatedHostId);
        return toString;
    }

    public AWSEC2TemplateOptions enableMonitoring() {
        this.monitoringEnabled = true;
        return this;
    }

    public AWSEC2TemplateOptions placementGroup(String placementGroup) {
        Preconditions.checkNotNull(Strings.emptyToNull(placementGroup), "use noPlacementGroup option instead of passing null");
        Preconditions.checkState(!this.noPlacementGroup, "you cannot specify both options placementGroup and noPlacementGroup");
        this.placementGroup = placementGroup;
        return this;
    }

    public AWSEC2TemplateOptions noPlacementGroup() {
        Preconditions.checkState(this.placementGroup == null, "you cannot specify both options placementGroup and noPlacementGroup");
        this.noPlacementGroup = true;
        return this;
    }

    public AWSEC2TemplateOptions subnetId(String subnetId) {
        this.subnetId = Preconditions.checkNotNull(Strings.emptyToNull(subnetId), "subnetId must be defined");
        return this;
    }

    @SinceApiVersion(value="2012-06-01")
    public AWSEC2TemplateOptions iamInstanceProfileArn(String arn) {
        this.iamInstanceProfileArn = Preconditions.checkNotNull(Strings.emptyToNull(arn), "arn must be defined");
        return this;
    }

    @SinceApiVersion(value="2012-06-01")
    public AWSEC2TemplateOptions iamInstanceProfileName(String name) {
        this.iamInstanceProfileName = Preconditions.checkNotNull(Strings.emptyToNull(name), "name must be defined");
        return this;
    }

    public AWSEC2TemplateOptions privateIpAddress(String address) {
        this.privateIpAddress = Preconditions.checkNotNull(Strings.emptyToNull(address), "address must be defined");
        return this;
    }

    public AWSEC2TemplateOptions tenancy(Tenancy tenancy) {
        this.tenancy = Preconditions.checkNotNull(tenancy, "tenancy must be defined");
        return this;
    }

    public AWSEC2TemplateOptions dedicatedHostId(String hostId) {
        this.dedicatedHostId = Preconditions.checkNotNull(Strings.emptyToNull(hostId), "hostId must be defined");
        return this;
    }

    public AWSEC2TemplateOptions spotPrice(Float spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    public AWSEC2TemplateOptions spotOptions(RequestSpotInstancesOptions spotOptions) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(12, 30);
        this.spotOptions = spotOptions != null ? spotOptions : RequestSpotInstancesOptions.Builder.validUntil(cal.getTime());
        return this;
    }

    public AWSEC2TemplateOptions securityGroupIds(String ... groupIds) {
        return this.securityGroupIds(ImmutableSet.copyOf(groupIds));
    }

    public AWSEC2TemplateOptions securityGroupIds(Iterable<String> groupIds) {
        Preconditions.checkArgument(!Iterables.isEmpty(groupIds), "you must specify at least one security group");
        for (String groupId : groupIds) {
            Preconditions.checkNotNull(Strings.emptyToNull(groupId), "all security groups must be non-empty");
        }
        this.groupIds = ImmutableSet.copyOf(groupIds);
        return this;
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    public AWSEC2TemplateOptions blockDeviceMappings(Iterable<? extends BlockDeviceMapping> blockDeviceMappings) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.blockDeviceMappings(blockDeviceMappings));
    }

    @Override
    public AWSEC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.userMetadata((Map)userMetadata));
    }

    @Override
    public AWSEC2TemplateOptions userMetadata(String key, String value) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.userMetadata(key, value));
    }

    @Override
    public AWSEC2TemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.nodeNames((Iterable)nodeNames));
    }

    @Override
    public AWSEC2TemplateOptions networks(Iterable<String> networks) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.networks((Iterable)networks));
    }

    @Override
    public AWSEC2TemplateOptions keyPair(String keyPair) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.keyPair(keyPair));
    }

    @Override
    public AWSEC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, Integer sizeInGib, boolean deleteOnTermination) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination));
    }

    @Override
    public AWSEC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.mapEphemeralDeviceToDeviceName(deviceName, virtualName));
    }

    @Override
    public AWSEC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination));
    }

    @Override
    public AWSEC2TemplateOptions noKeyPair() {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.noKeyPair());
    }

    @Override
    public AWSEC2TemplateOptions securityGroups(Iterable<String> groupIds) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.securityGroups((Iterable)groupIds));
    }

    @Override
    public AWSEC2TemplateOptions securityGroups(String ... groupIds) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.securityGroups(groupIds));
    }

    @Override
    public AWSEC2TemplateOptions unmapDeviceNamed(String deviceName) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.unmapDeviceNamed(deviceName));
    }

    @Override
    public AWSEC2TemplateOptions userData(byte[] unencodedData) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.userData(unencodedData));
    }

    @Override
    public AWSEC2TemplateOptions blockOnPort(int port, int seconds) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public AWSEC2TemplateOptions inboundPorts(int ... ports) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.inboundPorts(ports));
    }

    @Override
    public AWSEC2TemplateOptions authorizePublicKey(String publicKey) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    @Override
    public AWSEC2TemplateOptions installPrivateKey(String privateKey) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Override
    public AWSEC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    @Override
    public AWSEC2TemplateOptions dontAuthorizePublicKey() {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    @Override
    public AWSEC2TemplateOptions nameTask(String name) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public AWSEC2TemplateOptions runAsRoot(boolean runAsRoot) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public AWSEC2TemplateOptions runScript(Statement script) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.runScript(script));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginPassword(String password) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    @Override
    public AWSEC2TemplateOptions overrideLoginUser(String loginUser) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    @Override
    public AWSEC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public boolean shouldAutomaticallyCreatePlacementGroup() {
        return !this.noPlacementGroup;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Float getSpotPrice() {
        return this.spotPrice;
    }

    public RequestSpotInstancesOptions getSpotOptions() {
        return this.spotOptions;
    }

    @SinceApiVersion(value="2012-06-01")
    public String getIAMInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    @SinceApiVersion(value="2012-06-01")
    public String getIAMInstanceProfileName() {
        return this.iamInstanceProfileName;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public Tenancy getTenancy() {
        return this.tenancy;
    }

    public String getDedicatedHostId() {
        return this.dedicatedHostId;
    }

    public static class Builder {
        public static AWSEC2TemplateOptions overrideLoginUser(String user) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static AWSEC2TemplateOptions overrideLoginPassword(String password) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static AWSEC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static AWSEC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static AWSEC2TemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static AWSEC2TemplateOptions securityGroupIds(String ... groupNames) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.securityGroupIds(groupNames));
        }

        public static AWSEC2TemplateOptions securityGroupIds(Iterable<String> groupNames) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.securityGroupIds(groupNames));
        }

        public static AWSEC2TemplateOptions blockDeviceMappings(Set<? extends BlockDeviceMapping> blockDeviceMappings) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.blockDeviceMappings(blockDeviceMappings);
        }

        public static AWSEC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination);
        }

        public static AWSEC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination);
        }

        public static AWSEC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.mapEphemeralDeviceToDeviceName(deviceName, virtualName);
        }

        public static AWSEC2TemplateOptions unmapDeviceNamed(String deviceName) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.unmapDeviceNamed(deviceName);
        }

        public static AWSEC2TemplateOptions securityGroups(String ... groupIds) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.securityGroups(groupIds);
        }

        public static AWSEC2TemplateOptions securityGroups(Iterable<String> groupIds) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.securityGroups((Iterable)groupIds);
        }

        public static AWSEC2TemplateOptions keyPair(String keyPair) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.keyPair(keyPair);
        }

        public static AWSEC2TemplateOptions userData(byte[] unencodedData) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.userData(unencodedData);
        }

        public static AWSEC2TemplateOptions noKeyPair() {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.noKeyPair();
        }

        public static AWSEC2TemplateOptions placementGroup(String placementGroup) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.placementGroup(placementGroup);
        }

        public static AWSEC2TemplateOptions noPlacementGroup() {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.noPlacementGroup();
        }

        public static AWSEC2TemplateOptions enableMonitoring() {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.enableMonitoring();
        }

        public static AWSEC2TemplateOptions inboundPorts(int ... ports) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.inboundPorts(ports);
        }

        public static AWSEC2TemplateOptions blockOnPort(int port, int seconds) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static AWSEC2TemplateOptions installPrivateKey(String rsaKey) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static AWSEC2TemplateOptions authorizePublicKey(String rsaKey) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static AWSEC2TemplateOptions subnetId(String subnetId) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.subnetId(subnetId);
        }

        @SinceApiVersion(value="2012-06-01")
        public static AWSEC2TemplateOptions iamInstanceProfileArn(String arn) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.iamInstanceProfileArn(arn);
        }

        @SinceApiVersion(value="2012-06-01")
        public static AWSEC2TemplateOptions iamInstanceProfileName(String name) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.iamInstanceProfileName(name);
        }

        public static AWSEC2TemplateOptions privateIpAddress(String address) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.privateIpAddress(address);
        }

        public static AWSEC2TemplateOptions tenancy(Tenancy tenancy) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.tenancy(tenancy);
        }

        public static AWSEC2TemplateOptions dedicatedHostId(String hostId) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.dedicatedHostId(hostId);
        }

        public static AWSEC2TemplateOptions spotPrice(Float spotPrice) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.spotPrice(spotPrice);
        }

        public static AWSEC2TemplateOptions spotOptions(RequestSpotInstancesOptions spotOptions) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.spotOptions(spotOptions);
        }

        public static AWSEC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static AWSEC2TemplateOptions userMetadata(String key, String value) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.userMetadata(key, value));
        }

        public static AWSEC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        public static AWSEC2TemplateOptions nodeNames(Iterable<String> nodeNames) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static AWSEC2TemplateOptions networks(Iterable<String> networks) {
            AWSEC2TemplateOptions options = new AWSEC2TemplateOptions();
            return (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options.networks((Iterable)networks));
        }
    }
}

