/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.fallbacks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.net.URI;
import org.jclouds.Fallback;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.InvocationContext;

public class EndpointIfAlreadyExists
implements Fallback<URI>,
InvocationContext<EndpointIfAlreadyExists> {
    private URI endpoint;

    @Override
    public URI createOrPropagate(Throwable t) throws Exception {
        if (Preconditions.checkNotNull(t, "throwable") instanceof KeyAlreadyExistsException) {
            return this.endpoint;
        }
        throw Throwables.propagate(t);
    }

    @Override
    public EndpointIfAlreadyExists setContext(HttpRequest request) {
        return this.setEndpoint(request == null ? null : request.getEndpoint());
    }

    @VisibleForTesting
    EndpointIfAlreadyExists setEndpoint(@Nullable URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }
}

