/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.io.InputStream;

public class B2InputStreamExcerpt
extends InputStream {
    private static final int EOF = -1;
    private final InputStream inputStream;
    private final long start;
    private long pastEnd;
    private boolean haveDoneInitialSkip;
    private long iPosition;

    public B2InputStreamExcerpt(InputStream inputStream, long start, long length) {
        B2Preconditions.checkArgument(start >= 0L, "start must be non-negative.");
        this.inputStream = inputStream;
        this.start = start;
        this.pastEnd = start + length;
        this.haveDoneInitialSkip = false;
        this.iPosition = 0L;
    }

    @Override
    public int read() throws IOException {
        this.startIfNeeded();
        if (this.atEnd()) {
            return -1;
        }
        ++this.iPosition;
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.startIfNeeded();
        if (this.atEnd()) {
            return -1;
        }
        int actuallyRead = this.inputStream.read(b, off, Math.min(this.getRemaining(), len));
        if (actuallyRead == -1) {
            this.pastEnd = this.iPosition;
        } else if (actuallyRead > 0) {
            this.iPosition += (long)actuallyRead;
        }
        return actuallyRead;
    }

    @Override
    public long skip(long n) throws IOException {
        this.startIfNeeded();
        if (this.atEnd()) {
            return 0L;
        }
        long actuallySkipped = super.skip(Math.min(n, (long)this.getRemaining()));
        this.iPosition += actuallySkipped;
        return actuallySkipped;
    }

    @Override
    public int available() throws IOException {
        this.startIfNeeded();
        if (this.atEnd()) {
            return 0;
        }
        return Math.min(this.getRemaining(), this.inputStream.available());
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private void startIfNeeded() throws IOException {
        if (!this.haveDoneInitialSkip) {
            while (this.iPosition < this.start) {
                long actuallySkipped = this.inputStream.skip(this.start - this.iPosition);
                this.iPosition += actuallySkipped;
                if (actuallySkipped != 0L) continue;
                B2Preconditions.checkState(this.inputStream.read() == -1, "made no progress skipping and not at end of stream? inputStream is a " + this.inputStream.getClass().getCanonicalName());
                this.pastEnd = this.iPosition;
                break;
            }
            this.haveDoneInitialSkip = true;
        }
    }

    private boolean atEnd() {
        return this.iPosition >= this.pastEnd;
    }

    private int getRemaining() {
        B2Preconditions.checkState(this.iPosition < this.pastEnd);
        return (int)(this.pastEnd - this.iPosition);
    }

    public long getExcerptStart() {
        return this.start;
    }

    public long getExcerptLength() {
        return this.pastEnd - this.start;
    }
}

