/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ClientConfig;
import com.backblaze.b2.client.B2StorageClient;
import com.backblaze.b2.client.B2StorageClientFactory;
import com.backblaze.b2.util.B2Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class B2StorageClientFactoryPathBasedImpl
implements B2StorageClientFactory {
    private List<String> factoryClassNames = new ArrayList<String>();
    private B2StorageClientFactory factory;

    B2StorageClientFactoryPathBasedImpl() {
        this.registerClass("com.backblaze.b2.client.webApiHttpClient.B2StorageHttpClientFactory");
    }

    synchronized void registerClass(String className) {
        B2Preconditions.checkArgument(!this.factoryClassNames.contains(className), className + " was already registered?");
        this.factoryClassNames.add(0, className);
    }

    @Override
    public synchronized B2StorageClient create(B2ClientConfig config) {
        if (this.factory == null) {
            this.factory = this.findAndCreateFactory();
        }
        return this.factory.create(config);
    }

    private synchronized B2StorageClientFactory findAndCreateFactory() {
        for (String className : this.factoryClassNames) {
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                Object factory = ctor.newInstance(new Object[0]);
                if (!(factory instanceof B2StorageClientFactory)) {
                    throw new RuntimeException(className + " doesn't implement B2StorageClientFactory.");
                }
                return (B2StorageClientFactory)factory;
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("class " + className + " doesn't have a public no-argument constructor?", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("unable to instantiate " + className + ": " + e, e);
            }
        }
        throw new RuntimeException("can't find any of the registered classes.");
    }
}

