<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.0
 * @date 18/03/18
 * @time 11:41 AM
 * 
 */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
<div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='sharepoint'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Sharepoint Configuration</h4>
                    </div>
                    <div class="panel-body">
                        <form class="sharepointConfiguration" ng-submit="saveSharepointConfiguration()" data-parsley-validate>
                            <div class="form-group col-lg-6">
                                <label for="clientId">Client Id</label>
                                <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter your clientId" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created a Sharepoint app.</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="clientSecret">Client Secret</label>
                                <input type="text" class="form-control" name="clientSecret" id="clientSecret"value="<?=$data["clientSecretKey"]?>" placeholder="Enter your client secret" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Client Secret will be the id which was provided when you have created a Sharepoint app.</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="redirectURL">Redirect URL</label>
                                <input type="text" class="form-control" name="redirectURL" id="redirectURL" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter your redirect URL" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Enter the complete redirect URL, example:- http://www.example.com</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="clientResourceURL">Client Resource URL</label>
                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter your client Resource URL" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your share point app URL)</span>
                                    </div>
                            <br/><br/>
                            <a style="margin-right: 10px;" ng-click="downloadPackage()" class="btn btn-success pull-right ">Download Package</a>
                            <button style="margin-right: 10px;" type="submit" class="btn btn-success pull-right proxySave">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?php echo microtime();?>" type="text/javascript"></script>