<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
use Helpers\Form;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?></h4>
                    </div>

                    <div class="panel-body">
                        <form class="cloudConfiguration" id="cloudConfiguration" ng-submit="saveCloudConfiguration()" data-parsley-validate>
			    <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs hide" role="tablist">
                                <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                                <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            </ul>

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane" id="general">
                                    </br>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="blusyncDownloadPath">BluSync Download Path</label>
                                        <input type="text" class="form-control" name="blusyncDownloadPath" id="blusyncDownloadPath" value="<?=$data['blusyncDownloadPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="mntParacloudPath">Mnt Paracloud Path</label>
                                        <input type="text" class="form-control" name="mntParacloudPath" id="mntParacloudPath" value="<?=$data['mntParacloudPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudScriptsFolder">Parablu Installation Script Folder</label>
                                        <input type="text" class="form-control" name="cloudScriptsFolder" id="cloudScriptsFolder" value="<?=$data['cloudScriptsFolder']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsBinDir">Scripts Bin Directory</label>
                                        <input type="text" class="form-control" name="scriptsBinDir" id="scriptsBinDir" value="<?=$data['scriptsBinDir']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsVideoThumbnail">Scripts Video Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsVideoThumbnail" id="scriptsVideoThumbnail" value="<?=$data['scriptsVideoThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsGeneralThumbnail">Scripts General Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsGeneralThumbnail" id="scriptsGeneralThumbnail" value="<?=$data['scriptsGeneralThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudFileName">Parablu Installation File Name</label>
                                        <input type="text" class="form-control" name="cloudFileName" id="cloudFileName" value="<?=$data['cloudFileName']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudType">Parablu Installation Type</label>
                                        <input type="text" class="form-control" name="cloudType" id="cloudType" value="<?=$data['cloudType']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showLatestBkpInfo">Can Admin Restore Other Users' Data</label>
                                        <select class="form-control showLatestBkpInfo selectpicker" name="showLatestBkpInfo" id="showLatestBkpInfo" >
                                            <option value="true" <?php if($data["showLatestBkpInfo"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showLatestBkpInfo"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    
                                        
                                            <div class="form-group col-lg-6 hide">
                                                <label for="solrUrl">Solr URL</label>
                                                <input type="text" class="form-control" name="solrUrl" id="solrUrl" value="<?=$data['solrUrl']?>" placeholder="Enter Solr URL" required autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6 hide">
                                                <label for="canAdminRestoreAll">Can Admin Restore Other Users' Data</label>
                                                <select class="form-control canAdminRestoreAll selectpicker" name="canAdminRestoreAll" id="canAdminRestoreAll" >
                                                     <option value="true" <?php if($data["canAdminRestoreAll"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                     <option value="false" <?php if($data["canAdminRestoreAll"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                            <div class="form-group col-lg-6 hide">
                                                <label for="isAdminDeleteBackupFile">Can Admin Delete Other Users' Data</label>
                                                <select class="form-control isAdminDeleteBackupFile selectpicker" name="isAdminDeleteBackupFile" id="isAdminDeleteBackupFile" >
                                                    <option value="true" <?php if($data["isAdminDeleteBackupFile"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                    <option value="false" <?php if($data["isAdminDeleteBackupFile"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                </select>
                                            </div>
                                        
                                        
                                            <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="defaultBkpPolicyName">Default Backup Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultBkpPolicyName" id="defaultBkpPolicyName" placeholder="" required >
                                                         <?php if(!empty($data['backupPolicies1'])){ ?>
                                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                                            $label = $value;
                                                            if( strlen( $label ) > 25 ) {
                                                               $label = substr( $label, 0, 25 ) . '...';
                                                            }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultBkpPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <div class="form-group col-lg-6 hide">
                                                        <label for="defaultGuestBkpPolicyName">Default Guest Backup Policy Name</label>
                                                        <select class="form-control selectPolicyPicker" name="defaultGuestBkpPolicyName" id="defaultGuestBkpPolicyName" placeholder="" required >
                                                             <?php if(!empty($data['backupPolicies'])){ ?>
                                                                 <?php foreach($data['backupPolicies'] as $key => $value){ 
                                                                    $label = $value['name'];
                                                                    if( strlen( $label ) > 25 ) {
                                                                       $label = substr( $label, 0, 25 ) . '...';
                                                                    }?>
                                                                     <option value="<?=$value['name']?>" <?php if($data['defaultGuestBkpPolicyName'] == $value['name']){echo 'selected';}?>><?=$label?></option>
                                                                     </option>
                                                                 <?php } ?>
                                                             <?php } ?>
                                                         </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="defaultSyncPolicyName">Default Sync Policy Name</label>
                                                    <select class="form-control selectPolicyPicker" name="defaultSyncPolicyName" id="defaultSyncPolicyName" placeholder="" required >
                                                         <?php if(!empty($data['syncPolicies1'])){ ?>
                                                            <?php foreach($data['syncPolicies1'] as $key => $value){
                                                                $label = $value;
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }?>
                                                                 <option value="<?=$value?>" <?php if($data['defaultSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                 </option>
                                                             <?php } ?>
                                                         <?php } ?>
                                                     </select>
                                                </div>
                                                <div class="form-group col-lg-6 hide">
                                                        <label for="defaultGuestSyncPolicyName">Default Guest Sync Policy Name</label>
                                                        <select class="form-control selectPolicyPicker" name="defaultGuestSyncPolicyName" id="defaultGuestSyncPolicyName" placeholder="" required >
                                                             <?php if(!empty($data['syncPolicies1'])){ ?>
                                                                 <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                                                    $label = $value;
                                                                    if( strlen( $label ) > 25 ) {
                                                                       $label = substr( $label, 0, 25 ) . '...';
                                                                    }?>
                                                                     <option value="<?=$value?>" <?php if($data['defaultGuestSyncPolicyName'] == $value){echo 'selected';}?>><?=$label?></option>
                                                                     </option>
                                                                 <?php } ?>
                                                             <?php } ?>
                                                         </select>
                                                </div>
                                            <?php } ?>
                                            <?php if(\Helpers\Auth::checkCloudPermission('office365')){ ?>
                                                <div class="form-group col-lg-6 hide">
                                                    <label for="odbPolicyName"><?=Language::show('Default Office 365 Policy Name', 'keywords');?></label><br/>
                                                    <select class="form-control selectPolicyPicker" name="defaultO365PolicyName" id="defaultO365PolicyName" required="">
                                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                                            <?php foreach($data['odbPolicies1'] as $key => $value){ 
                                                                $label = $value['name'];
                                                                if( strlen( $label ) > 25 ) {
                                                                   $label = substr( $label, 0, 25 ) . '...';
                                                                }
                                                            ?>
                                                            <option value="<?=$value['name']?>" <?php if($data['defaultO365PolicyName'] == $value['name']){echo 'selected';}?>><?=$value['name']?></option>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            <?php } ?>
                                </div>
                                <div role="tabpanel" class="tab-pane active" id="advanced">
                                    </br>
				    <div class="form-group col-lg-6 hide">
                                     	<label class="form-control" for="defaultBkpPolicyName">No Backup Policy Name</label>
                                     	<input type="text" class="form-control" name="noBackupPolicyName" id="noBackupPolicyName" value="<?=$data['noBackupPolicyName']?>" placeholder="" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="muxedEnabled">Is Muxed Enabled</label>
                                        <select class="form-control muxedEnabled selectpicker" name="muxedEnabled" id="muxedEnabled" >
                                            <option value="false" <?php if($data["muxedEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["muxedEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6">
                                            <label for="softBlockEnabled">Enable administration approval for blocked users</label>
                                            <select class="form-control softBlockEnabled selectpicker" name="softBlockEnabled" id="softBlockEnabled" >
                                                <option value="false" <?php if($data["softBlockEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="true" <?php if($data["softBlockEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="azureVM">Azure VM</label>
                                        <select class="form-control azureVM selectpicker" name="azureVM" id="azureVM" >
                                            <option value="false" <?php if($data["azureVM"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["azureVM"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="localAD">Local AD</label>
                                        <select class="form-control localAD selectpicker" name="localAD" id="localAD" >
                                            <option value="true" <?php if($data["localAD"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["localAD"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="sslAuthEnabled">SSl Auth Enabled</label>
                                        <select class="form-control sslAuthEnabled selectpicker" name="sslAuthEnabled" id="sslAuthEnabled" >
                                            <option value="false" <?php if($data["sslAuthEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["sslAuthEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="reportRows">Report Rows</label>
                                        <input type="number" class="form-control" name="reportRows" id="reportRows" value="<?=$data['reportRows']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                         <label for="storageLimitInKb">Storage Limit In Kb</label>
                                         <input type="number" class="form-control" name="storageLimitInKb" id="storageLimitInKb" value="<?=$data['storageLimitInKb']?>" placeholder="" autocomplete="off">
                                     </div>
                                    <div class="form-group col-lg-6  hide">
                                        <label for="isCrawlEnabled">Is Crawl Enabled</label>
                                        <select class="form-control isCrawlEnabled selectpicker" name="isCrawlEnabled" id="isCrawlEnabled" >
                                            <option value="false" <?php if($data["isCrawlEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["isCrawlEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="isShareFileNameEnabled">Is Share File Name Enabled</label>
                                        <select class="form-control isShareFileNameEnabled selectpicker" name="isShareFileNameEnabled" id="isShareFileNameEnabled" >
                                            <option value="true" <?php if($data["isShareFileNameEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["isShareFileNameEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6  hide">
                                        <label for="maxCrawlHit">Maximum Crawl Hit</label>
                                        <input type="number" class="form-control" name="maxCrawlHit" id="maxCrawlHit" value="<?=$data['maxCrawlHit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="noOfMultiADConfig">No. Of Multi AD Configuration</label>
                                        <input type="number" class="form-control" name="noOfMultiADConfig" id="noOfMultiADConfig" value="<?=$data['noOfMultiADConfig']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide" style="margin-bottom:20px;">
                                        <label for="mongoReadPreference">Mongo Read Preference</label>
                                        <select class="form-control mongoReadPreference selectpicker" name="mongoReadPreference" id="mongoReadPreference" >
                                            <option value="false" <?php if($data["mongoReadPreference"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                            <option value="true" <?php if($data["mongoReadPreference"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="writeConcernLimit">Write Concern Limit</label>
                                        <input type="number" class="form-control" name="writeConcernLimit" id="writeConcernLimit" value="<?=$data['writeConcernLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="ebmsWriteDelayLimit">EBMS Write Delay Limit</label>
                                        <input type="number" class="form-control" name="ebmsWriteDelayLimit" id="ebmsWriteDelayLimit" value="<?=$data['ebmsWriteDelayLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="emailBkpGroupName">Email Backup Group Name</label>
                                        <input type="text" class="form-control" name="emailBkpGroupName" id="emailBkpGroupName" value="<?=$data['emailBkpGroupName']?>" placeholder="Enter Email Backup Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="emailSyncGroupName">Email Sync Group Name</label>
                                        <input type="text" class="form-control" name="emailSyncGroupName" id="emailSyncGroupName" value="<?=$data['emailSyncGroupName']?>" placeholder="Enter Email Sync Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="bkpGroupEmail">Backup Group Email</label>
                                        <input type="email" class="form-control" name="bkpGroupEmail" id="bkpGroupEmail" value="<?=$data['bkpGroupEmail']?>" placeholder="Enter Backup group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="syncGroupEmail">Sync Group Email</label>
                                        <input type="email" class="form-control" name="syncGroupEmail" id="syncGroupEmail" value="<?=$data['syncGroupEmail']?>" placeholder="Enter Sync group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="chunkUpdateMaxRetry">Number of times to retry when updating chunk detail table</label>
                                        <input type="number" class="form-control" name="chunkUpdateMaxRetry" id="chunkUpdateMaxRetry" value="<?=$data['chunkUpdateMaxRetry']?>" placeholder="Enter value" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientMailName">Client Mail Name</label>
                                        <input type="text" class="form-control" name="clientMailName" id="clientMailName" value="<?=$data['clientMailName']?>" placeholder="Enter client Mail Name" required autocomplete="off">
                                    </div>
                                    <div class="row" style="margin-left:10px;">
                                        <legend class="h4" style="color: #585f69;"><?=Language::show('Delegated Administrator Settings', 'keywords')?></legend>
                                        <div class="form-group col-lg-6">
                                                <label for="hideDashboard">Show Dashboard Tiles for Delegated Administrator</label>
                                                <select class="form-control hideDashboard selectpicker" name="hideDashboard" id="hideDashboard" >
                                                <option value="false" <?php if($data["hideDashboard"] == false){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="true" <?php if($data["hideDashboard"] == true){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group col-lg-6">
                                                <label for="policyEdit">Allow Policy Management</label>
                                                <select class="form-control policyEdit selectpicker" name="policyEdit" id="policyEdit" >
                                                <option value="true" <?php if($data["policyEdit"] == true){echo "selected";}?>>Yes</option>
                                                <option value="false" <?php if($data["policyEdit"] == false){echo "selected";}?>>No</option>
                                                </select>
                                        </div>
					<div class="form-group col-lg-6">           
                                                <label for="showAuditHistory">Show Audit History for Delegated Administrator</label>
                                                <select class="form-control showAuditHistory selectpicker" name="showAuditHistory" id="showAuditHistory" >
                                                <option value="true" <?php if($data["showAuditHistory"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["showAuditHistory"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                        </div>
                                        <div class="form-group col-lg-6 hide">
                                                <label for="hideDashboard">Stop Pause Access for Read Only Admin</label>
                                                <select class="form-control stopPauseAccess selectpicker" name="stopPauseAccess" id="stopPauseAccess" >
                                                <option value="true" <?php if($data["stopPauseAccess"] == true){echo "selected";}?>>Yes</option>
                                                <option value="false" <?php if($data["stopPauseAccess"] == false){echo "selected";}?>>No</option>
                                                </select>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="">Extensions To Pdf View</label>
                                        <input type="text" class="form-control" name="extensionsToPdfView" id="extensionsToPdfView" value="<?=$data['extensionsToPdfView']?>" placeholder="" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="solrServerUrl">Solr Server Url</label>
                                        <input type="text" class="form-control" name="solrServerUrl" id="solrServerUrl" value="<?=$data['solrServerUrl']?>" placeholder="Enter Solr Server Url" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="supportMail">Server alert email ID</label>
                                        <input type="text" class="form-control" name="supportMail" id="supportMail" value="<?=$data['supportMail']?>" placeholder="Enter Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="clientSupportMailName">Administrator contact email ID</label>
                                        <input type="email" class="form-control" name="clientSupportMailName" id="clientSupportMailName" value="<?=$data['clientSupportMailName']?>" placeholder="Enter client Support Mail Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="adGroupName">Enter AD Group Name</label>
                                        <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="<?=$data['adGroupName']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>

                                    <div class="form-group col-lg-6 hide">
                                        <label for="adfsUrl">ADFS URL</label>
                                        <input type="text" class="form-control" name="adfsUrl" id="adfsUrl" value="<?=$data['adfsUrl']?>" placeholder="Enter ADFS URL" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="isDomainCheckEnabled">Is Domain Check Enabled</label>
                                        <select class="form-control isDomainCheckEnabled selectpicker" name="isDomainCheckEnabled" id="isDomainCheckEnabled" >
                                            <option value="true" <?php if($data["isDomainCheckEnabled"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["isDomainCheckEnabled"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
 				                    <div class="form-group col-lg-6 hide">
                                        <label for="bulkEmailDelay">Bulk Email Delay (In Seconds)</label>
                                        <input type="text" class="form-control" name="bulkEmailDelay" id="bulkEmailDelay" value="<?=$data['bulkEmailDelay']?>" onfocusout="myFunctionEmailDelay();" placeholder="Enter Bulk Email Delay" required autocomplete="off">
                                        <span id="delayerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="supportParacloudUrl">Support Paracloud Url</label>
                                        <input type="text" class="form-control" name="supportParacloudUrl" id="supportParacloudUrl" value="<?=$data['supportParacloudUrl']?>" placeholder="Enter supportParacloudUrl" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="reportRows">Days To Wait For Next Backup</label>
                                        <input type="number" class="form-control" name="daysToWaitForNextBackup" id="daysToWaitForNextBackup" value="<?=$data['daysToWaitForNextBackup']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="dnsUserName">DNS Username</label>
                                        <input type="text" class="form-control" name="dnsUserName" id="dnsUserName" value="<?=$data['dnsUserName']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="dnsPassword">DNS Password</label>
                                        <input type="text" class="form-control" name="dnsPassword" id="dnsPassword" value="<?=$data['dnsPassword']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="adEmailConfig">AD Email Config</label>
                                        <input type="text" class="form-control" name="adEmailConfig" id="adEmailConfig" value="<?=$data['adEmailConfig']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="hideCompressedSize">Hide Compressed Size</label>
                                        <select class="form-control hideCompressedSize selectpicker" name="hideCompressedSize" id="hideCompressedSize" >
                                        <option value="true" <?php if($data["hideCompressedSize"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["hideCompressedSize"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6  hide" style="margin-bottom:20px;">
                                        <label for="hideStorageSizeInCloud">Hide Storage Size In Cloud</label>
                                        <select class="form-control hideStorageSizeInCloud selectpicker" name="hideStorageSizeInCloud" id="hideStorageSizeInCloud" >
                                        <option value="true" <?php if($data["hideStorageSizeInCloud"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data["hideStorageSizeInCloud"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                            <label for="enableRecaptcha">Enable Google reCAPTCHA</label>
                                            <select class="form-control enableRecaptcha selectpicker" name="enableRecaptcha" id="enableRecaptcha" >
                                                <option value="false" <?php if($data["enableRecaptcha"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="true" <?php if($data["enableRecaptcha"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="portalSSOEnable"><?=Language::show('portalSSOEnable', 'keywords');?></label>
                                        <select class="form-control portalSSOEnable" name="portalSSOEnable" id="portalSSOEnable" title='Select <?=Language::show('Portal SSO Enable', 'keywords')?>'>
                                            <option value="true" <?php if($data["portalSSOEnable"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["portalSSOEnable"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">
                                        <label for="gatewayNameChanged"><?=Language::show('gatewayNameChanged', 'keywords');?></label>
                                        <select class="form-control gatewayNameChanged" name="gatewayNameChanged" id="gatewayNameChanged" title='Select <?=Language::show('Gateway Name Changed', 'keywords')?>'>
                                            <option value="true" <?php if($data["gatewayNameChanged"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["gatewayNameChanged"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">
                                           <label for="portalSSOutEnable"><?=Language::show('Azure Active Directory Single SignOut from Portal', 'keywords');?></label>
                                           <select class="form-control portalSSOutEnable" name="portalSSOutEnable" id="portalSSOutEnable" title='Select <?=Language::show('Portal SSOut Enable', 'keywords')?>'>
                                                <option value="true" <?php if($data["portalSSOutEnable"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" <?php if($data["portalSSOutEnable"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                           </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">
                                                <label for="useLocalPackage">Use Local Package</label>
                                                <select class="form-control useLocalPackage" name="useLocalPackage" id="useLocalPackage" >
                                                <option value="true" <?php if($data["useLocalPackage"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["useLocalPackage"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">
                                                <label for="showSupportPage">Show Support Page</label>
                                                <select class="form-control showSupportPage" name="showSupportPage" id="showSupportPage" >
                                                <option value="true" <?php if($data["showSupportPage"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["showSupportPage"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                    </div>
    				    <div class="form-group col-lg-6 hide">
                                                <label for="showCurrentlyRunningReports">Show Currently Running Reports for Delegated Administrator</label>
                                                <select class="form-control showCurrentlyRunningReports" name="showCurrentlyRunningReports" id="showCurrentlyRunningReports" >
                                                <option value="true" <?php if($data["showCurrentlyRunningReports"] == true){echo "selected";}?>><?=Language::show('Yes', 'keywords')?></option>
                                                <option value="false" <?php if($data["showCurrentlyRunningReports"] == false){echo "selected";}?>><?=Language::show('No', 'keywords')?></option>
                                                </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showBackupOverview"><?=Language::show('Show Backup Overview Report', 'keywords');?></label>
                                        <select class="form-control showBackupOverview" name="showBackupOverview" id="showBackupOverview" title='Select <?=Language::show('showBackupOverview', 'keywords')?>'>
                                            <option value="true" <?php if($data["showBackupOverview"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option> 
                                            <option value="false" <?php if($data["showBackupOverview"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showBackupHistory"><?=Language::show('Show Backup History Report', 'keywords');?></label>
                                        <select class="form-control showBackupHistory" name="showBackupHistory" id="showBackupHistory" title='Select <?=Language::show('showBackupHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showBackupHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showBackupHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showFailedBackupHistory"><?=Language::show('Show Failed Backup History Report', 'keywords');?></label>
                                        <select class="form-control showFailedBackupHistory" name="showFailedBackupHistory" id="showFailedBackupHistory" title='Select <?=Language::show('showFailedBackupHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showFailedBackupHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showFailedBackupHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                     <label for="showSystemsWithoutBackups"><?=Language::show('Show Systems Without Backups Report', 'keywords');?></label>
                                        <select class="form-control showSystemsWithoutBackups" name="showSystemsWithoutBackups" id="showSystemsWithoutBackups" title='Select <?=Language::show('showSystemsWithoutBackups', 'keywords')?>'>
                                            <option value="true" <?php if($data["showSystemsWithoutBackups"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showSystemsWithoutBackups"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showRestoreHistory"><?=Language::show('Show Restore History Report', 'keywords');?></label>
                                        <select class="form-control showRestoreHistory" name="showRestoreHistory" id="showRestoreHistory" title='Select <?=Language::show('showRestoreHistory', 'keywords')?>'>
                                            <option value="true" <?php if($data["showRestoreHistory"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showRestoreHistory"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showStorageUtilizationReport"><?=Language::show('Show Storage Utilization Report', 'keywords');?></label>
                                        <select class="form-control showStorageUtilizationReport" name="showStorageUtilizationReport" id="showStorageUtilizationReport" title='Select <?=Language::show('showStorageUtilizationReport', 'keywords')?>'>
                                            <option value="true" <?php if($data["showStorageUtilizationReport"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showStorageUtilizationReport"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                    <label for="showDeviceHeartbeatReport"><?=Language::show('Show Device Heart beat Report', 'keywords');?></label>
                                        <select class="form-control showDeviceHeartbeatReport" name="showDeviceHeartbeatReport" id="showDeviceHeartbeatReport" title='Select <?=Language::show('showDeviceHeartbeatReport', 'keywords')?>'>
                                            <option value="true" <?php if($data["showDeviceHeartbeatReport"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showDeviceHeartbeatReport"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="showUserBackupSummary"><?=Language::show('Show User Backup Summary', 'keywords');?></label>
                                        <select class="form-control showUserBackupSummary" name="showUserBackupSummary" id="showUserBackupSummary" title='Select <?=Language::show('showUserBackupSummary', 'keywords')?>'>
                                            <option value="true" <?php if($data["showUserBackupSummary"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["showUserBackupSummary"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="dbBackupPassword">DB Backup Password</label>
                                        <input type="password" class="form-control" name="dbBackupPassword" id="dbBackupPassword" value="<?=$data['dbBackupPassword']?>" placeholder="Enter DB Backup Password" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">  
                                        <label for="winDeviceDisplayNameUpdate">Allow Windows Device Display Name Update</label>
                                        <select class="form-control winDeviceDisplayNameUpdate selectpicker" name="winDeviceDisplayNameUpdate" id="winDeviceDisplayNameUpdate" >
                                        <option value="true" <?php if($data["winDeviceDisplayNameUpdate"] == true){echo "selected";}?>>Enabled</option>
                                        <option value="false" <?php if($data["winDeviceDisplayNameUpdate"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="macDeviceDisplayNameUpdate">Allow Mac Device Display Name Update</label>
                                        <select class="form-control macDeviceDisplayNameUpdate selectpicker" name="macDeviceDisplayNameUpdate" id="macDeviceDisplayNameUpdate" >
                                        <option value="true" <?php if($data["macDeviceDisplayNameUpdate"] == true){echo "selected";}?>>Enabled</option>
                                        <option value="false" <?php if($data["macDeviceDisplayNameUpdate"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">  
                                        <label for="brevityLogging">Brevity Logging</label>
                                        <select class="form-control brevityLogging selectpicker" name="brevityLogging" id="brevityLogging" >
                                        <option value="true" <?php if($data["brevityLogging"] == true){echo "selected";}?>>Enabled</option>
                                        <option value="false" <?php if($data["brevityLogging"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">  
                                        <label for="globalCheckForLocalStorage">Global Check For Local Storage</label>
                                        <select class="form-control globalCheckForLocalStorage selectpicker" name="globalCheckForLocalStorage" id="globalCheckForLocalStorage" >
                                        <option value="true" <?php if($data["globalCheckForLocalStorage"] == true){echo "selected";}?>>Enabled</option>
                                        <option value="false" <?php if($data["globalCheckForLocalStorage"] == false){echo "selected";}?>>Disabled</option>
                                        </select>
                                    </div>
				    <div class="col-lg-12 hide">
                                        <div class="form-group col-lg-6 complexPassword">
                                        <label for="complexPassword">Complex password</label>
                                        <select class="form-control complexPassword" name="complexPassword" required="" title='Select complex Password option'>
                                            <option value="true" <?php if($data["complexPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["complexPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 eyeOption hide">
                                        <label for="eyeOption">Password Visibility</label>
                                        <select class="form-control eyeOption" name="eyeOption">
                                            <option value="true" <?php if($data["eyeOption"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["eyeOption"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">
                                        <label for="enableRecaptcha">Google reCAPTCHA</label>
                                        <select class="form-control enableRecaptcha selectpicker" name="enableRecaptcha" id="enableRecaptcha" >
                                            <option value="true" <?php if($data["enableRecaptcha"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["enableRecaptcha"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6 hide">
                                            <label for="googleAuthenticator">Enable Google Authenticator</label>
                                            <select class="form-control googleAuthenticator selectpicker" name="googleAuthenticator" id="googleAuthenticator" >
                                                <option value="false" <?php if($data["googleAuthenticator"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="true" <?php if($data["googleAuthenticator"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            </select>
                                     </div>
				     <div class="form-group col-lg-6 hide" style="border: 1px solid #b2b2b2b2;border-radius: 5px;width: 49%;">
                                            <div class="col-lg-8">
                                                <label>Tile 4</label>
                                                <select class="form-control" name="tile4" id="tile4">
                                                <option value="true" <?php if($data["totalCompletedBackups"] == true){echo "selected";}?>>Show "Total Completed Backups" in front</option>
                                                <option value="false" <?php if($data["totalCompletedBackups"] == false){echo "selected";}?>>Show "Full Backup Completed" in front</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-4">
                                                <label for="tile4flip">Make Tile 4 flipable</label>
                                                <label class="switch">
                                                <input id="tile4flip" name="tile4flip" type="checkbox" <?php if($data["flipTotalCompletedBackups"] == true){echo "checked";}?>>
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                      </div>
				      <div class="form-group col-lg-6 hide" style="border: 1px solid #b2b2b2;margin-left: 3%;border-radius: 5px;width: 48%;">
                                            <div class="col-lg-8">
                                                <label>Tile 5</label>
                                                <select class="form-control" name="tile5" id="tile5">
                                                    <option value="true" <?php if($data["totalActualStorageUtilized"] == true){echo "selected";}?>>Show "Total Actual Storage Utilized" in front</option>
                                                    <option value="false" <?php if($data["totalActualStorageUtilized"] == false){echo "selected";}?>>Show "Total Data Backed up" in front</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-4">
                                                <label for="tile5flip">Make Tile 5 flipable</label>
                                                <label class="switch">
                                                <input id="tile5flip" name="tile5flip" type="checkbox" <?php if($data["flipTotalActualStorageUtilized"] == true){echo "checked";}?>>
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
				     <div class="form-group col-lg-6 hide" <?php if(!isMobile()){ ?> style="border: 1px solid #b2b2b2;border-radius: 5px;width: 49%;" <?php } else { ?> style="border: 1px solid #b2b2b2;border-radius: 5px;"<?php } ?>>
                                            <div class="col-lg-8">
                                                <label>Tile 8</label>
                                                <select class="form-control" name="tile8ReportType" id="tile8">
                                                    <option value="systemsWithoutBackup" <?php if($data["tile8ReportType"] == "systemsWithoutBackup"){echo "selected";}?>>Open "Systems without backups" report</option>
                                                    <option value="userBackupSummary" <?php if($data["tile8ReportType"] == "userBackupSummary"){echo "selected";}?>>Open "User Backup Summary" report</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-4 hide">
                                                <label for="tile8flip">Make Tile 8 flipable</label>
                                                <label class="switch">
                                                <input id="tile8flip" name="tile8flip" type="checkbox" <?php if($data["flipTotalActualStorageUtilized"] == true){echo "checked";}?>>
                                                <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                <div class="row  hide">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69;"><?=Language::show('Environment Level Password Enforcement', 'keywords')?></legend>
                                    <!-- Default checked -->
                                    <div class="form-group col-lg-12">
                                        <input type="checkbox" class="custom-control-input hide" id="controller">
                                        <label class="hide" for="controller">Enforce Rules</label>
                                        <span><p>Enforce Rules</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
                                            <label class="switch">
                                            <input id="controller1" type="checkbox" name="passwordChangeEnforce" value="true" <?php if($data["passwordChangeEnforce"] == true){echo "checked";}?>>
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6 canUserChangePassword1">
                                        <label for="canUserChangePassword1">Can User Change Password</label>
                                        <select class="form-control canUserChangePassword1" name="canUserChangePassword1" required="" title='Select <?=Language::show('canUserChangePassword1', 'keywords')?>' <?php if($data["passwordChangeEnforce"] == false){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canUserChangePassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canUserChangePassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 canAdminChangeUserPassword1">
                                        <label for="canAdminChangeUserPassword1">Can Admin Change User Password</label>
                                        <select class="form-control canAdminChangeUserPassword1" name="canAdminChangeUserPassword1" <?php if($data["passwordChangeEnforce"] == false){echo "disabled";}?>>
                                            <option value="true" <?php if($data["canAdminChangeUserPassword"] == true){echo "selected";}?>><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" <?php if($data["canAdminChangeUserPassword"] == false){echo "selected";}?>><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="hide">
                                      <input type="checkbox" class="custom-control-input canUserChangePassword">
                                      <label class="custom-control-label" for="canUserChangePassword">Can User Change Password</label>
                                    </div>
                                    <div class="hide">
                                      <input type="checkbox" class="custom-control-input canAdminChangeUserPassword">
                                      <label class="custom-control-label" for="canAdminChangeUserPassword">Can Admin Change User Password</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                            </div>
                            <br/>
                            <div class="form-group col-lg-12">
                                <button type="submit" class="btn btn-success pull-right saveCloudProperties">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script type="text/javascript">
    
    function myFunctionEmailDelay(){
        document.getElementById("delayerror").innerHTML = "";
        if(isNaN($('#bulkEmailDelay').val()))
        {
        if (  $('#bulkEmailDelay').val() !='NO DELAY')  {
                document.getElementById("delayerror").innerHTML = "Input can be either 'NO DELAY' or any integer";
                //alert('Invalid Input');
            }
        }
        else{
            document.getElementById("delayerror").innerHTML = "";
        }
    }
    
    $("#switchFairnessAlgorithm").click(function(){
         if ($(this).is(':checked')) {
             $('#daysToWaitForNextBackup').removeAttr('disabled');
         } else {
             $('#daysToWaitForNextBackup').val('0');
             $('#daysToWaitForNextBackup').attr('disabled', true); 
         }
     });


    $('#controller1').click(function(){
        if ($(this).is(':checked')) {
            console.log("checked");
            $('.canUserChangePassword1').attr("disabled", false);
            $('.canAdminChangeUserPassword1').attr("disabled", false);      
            $('.canUserChangePassword1').find('option[value="true"]').prop("selected",true);     
         } else {
            console.log("unchecked");
            $('.canUserChangePassword1').find('option[value="true"]').prop("selected",true);  
            $('.canAdminChangeUserPassword1').find('option[value="false"]').prop("selected",true);  
            $('.canUserChangePassword1').attr('disabled', true); 
            $('.canAdminChangeUserPassword1').attr('disabled', true); 
             
         }

    });
</script>
<style>
 .switch {
   position: relative;
   display: inline-block;
   width: 60px;
   height: 34px;
 }
 
 .switch input {display:none;}
 
 .slider {
   position: absolute;
   cursor: pointer;
   top: 0;
   left: 0;
   right: 0;
   bottom: 0;
   background-color: #ccc;
   -webkit-transition: .4s;
   transition: .4s;
 }
 
 .slider:before {
   position: absolute;
   content: "";
   height: 26px;
   width: 26px;
   left: 4px;
   bottom: 4px;
   background-color: white;
   -webkit-transition: .4s;
   transition: .4s;
 }
 
 input:checked + .slider {
   background-color: #2196F3;
 }
 
 input:focus + .slider {
   box-shadow: 0 0 1px #2196F3;
 }
 
 input:checked + .slider:before {
   -webkit-transform: translateX(26px);
   -ms-transform: translateX(26px);
   transform: translateX(26px);
 }
 /* Rounded sliders */
 .slider.round {
   border-radius: 34px;
 }
 
 .slider.round:before {
   border-radius: 50%;
 }
 </style>
