<?php use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('servers');?>" ><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ServerController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="currentPage hide">updateContainerList</span>
            <div class="row serverContainer" block-ui="myBlockUI" style="min-height: 200px;">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4>
                            Containers
                            <a class="pull-right btn btn-small btn-success" data-toggle="modal" data-target=".createNewContainer">Create New Container</a>
                        </h4>
                    </div>
                    <div class="panel-body containerListContainer" style="display: none">
                        <div class="status">
                            <h4 align="center">Loading...</h4>
                        </div>
                        <div ng-if="containerList.length > 0" ng-repeat="value in containerList track by $index" class="col-lg-4 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-inbox"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <span>
                                        <a>Container Name: </a><a ng-cloak class="pull-right">{{ value.containerName }}</a>
                                        <hr/>
                                    </span>
                                    <span>
                                        <a>Container type: </a><a ng-cloak class="pull-right">{{ value.containerType }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.containerLocation.length > 0">
                                        <a>File Source Location: </a><a ng-cloak class="pull-right">{{ value.containerLocation }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.username.length > 0">
                                        <a>Database UserName: </a><a ng-cloak class="pull-right">{{ value.username }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.password.length > 0">
                                        <a>Database Password: </a><a ng-cloak class="pull-right">******</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.port.length > 0">
                                        <a>Database Port: </a><a ng-cloak class="pull-right">{{ value.port }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.nextScheduledBackup.length > 0">
                                        <a>Next Scheduled Backup: </a><a ng-cloak class="pull-right">{{ value.nextScheduledBackup }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.nextPolicyRefresh.length > 0">
                                        <a>Policy Refresh Frequency: </a><a ng-cloak class="pull-right">{{ value.nextPolicyRefresh }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.backupPolicyName.length > 0">
                                        <a>Backup Policy Name: </a><a ng-cloak class="pull-right">{{ value.backupPolicyName }}</a>
                                        <br/>
                                    </span>
                                    <?php if(LDAP_ENABLED == true){ ?>
                                    <span ng-if="value.backupPolicyName.length > 0">
                                        <a>User Group Name: </a><a ng-cloak class="pull-right">{{ value.groupName }}</a>
                                    </span>
                                    <?php } ?>
                                </div>
                                <div class="panel-footer">
                                    <?php if($_SESSION['readOnlyAdmin'] == true){ ?>
                                        <a style="margin-top: 5px;" ng-click="sendMeTo('<?=Url::basePath('server/restore/'.$data['deviceUUID'].'/'.addslashes($data['deviceName']).'/')?>'+value.containerName)" class="btn btn-small btn-primary">View Backups</a>
                                    <?php }else{ ?>
                                        <a style="margin-top: 5px;" ng-click="setSessionAndSendMeTo('<?=Url::basePath('server/restore/'.$data['deviceUUID'].'/'.addslashes($data['deviceName']).'/')?>'+value.containerName, value.containerType)" class="btn btn-small btn-primary">Initiate Restore</a>
                                        <a style="margin-top: 5px;" class="btn btn-primary btn-small refreshPolicyBTN{{$index}}" ng-click="refreshPolicy('<?=addslashes($data['deviceName'])?>', $index)" >Refresh Policy</a>
                                        <a style="margin-top: 5px;" class="btn btn-primary btn-small decoupleAgent{{$index}}" ng-click="decoupleAgent('<?=addslashes($data['deviceName'])?>', $index)" >Decouple Agent</a>
                                        <a style="margin-top: 5px;" ng-bootbox-title="Backup Options"
                                           ng-bootbox-custom-dialog="What type of backup do you want to run?"
                                           ng-bootbox-buttons="backupOptions"
                                           class="btn btn-small btn-primary"
                                           ng-click="markAsSelectedServerForAction('<?=addslashes($data['deviceName'])?>', value.containerName)">Adhoc Backup</a>
                                        <a style="margin-top: 5px;" class="btn btn-primary btn-small" ng-click="editContainerDetails($index)">Edit</a>
                                        <a style="margin-top: 5px;" class="btn btn-danger btn-small"
                                           ng-bootbox-confirm="<?=Language::show('Are you sure you want to remove {{ value.containerName }} container?', 'keywords')?>"
                                           ng-bootbox-confirm-action="removeContainer($index, '<?=addslashes($data['deviceName'])?>')"
                                           ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('Remove Container', 'keywords');?></a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade createNewContainer" tabindex="-1" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <?=
                        Form::open(array(
                            'ng-submit' => 'saveNewContainerPolicyDetails()',
                            'method' => 'post',
                            'class' => 'attachContainerNewForm',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Create Container</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-lg-6 hide">
                                    <label for="action"><?=Language::show('deviceUUID', 'keywords');?></label>
                                    <input type="text" value="create" class="form-control" name="action" id="action" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('action', 'keywords');?>" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 hide">
                                    <label for="deviceUUID"><?=Language::show('deviceUUID', 'keywords');?></label>
                                    <input type="text" value="<?=$data['deviceUUID']?>" class="form-control" name="deviceUUID" id="deviceUUID" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('deviceUUID', 'keywords');?>" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="containerName"><?=Language::show('containerName', 'keywords');?></label>
                                    <input type="text" class="form-control" name="containerName" id="containerName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('containerName', 'keywords');?>" required autocomplete="off" >
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="containerType"><?=Language::show('containerType', 'keywords');?></label>
                                    <select class="containerType form-control" name="containerType" id="containerType" required>
                                        <?php if(!empty(CONTAINER_TYPES)){ ?>
                                            <option selected disabled>Please Select a container Type</option>
                                            <?php foreach(explode(',', CONTAINER_TYPES) as $key => $value){ ?>
                                                <option value="<?=str_replace(' ', '', strtolower($value))?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php }else{ ?>
                                            <option selected disabled>Please define database types</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-lg-6">
                                    <label for="containerPolicy"><?=Language::show('containerPolicy', 'keywords');?></label>
                                    <select class="selectpicker form-control" name="containerPolicy" id="containerPolicy" required>
                                        <?php if(!empty($data['policies'])){ ?>
                                            <?php foreach($data['policies'] as $key => $value){ ?>
                                                <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } else{ ?>
                                            <option selected disabled>Please create a policy</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php if(LDAP_ENABLED == true){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="userGroup"><?=Language::show('userGroup', 'keywords');?></label>
                                    <select class="selectpicker form-control" name="userGroup" id="userGroup" required>
                                        <?php if(!empty($data['groups'])){ ?>
                                            <option selected disabled>Please Select a group</option>
                                            <?php foreach($data['groups'] as $key => $value){ ?>
                                                <option value="<?=str_replace(' ', '', strtolower($value->name))?>"><?=$value->name?></option>
                                            <?php } ?>
                                        <?php }else{ ?>
                                            <option selected disabled>Please create a group</option>
                                            <option value="example">Example</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <?php } ?>
                            </div>
                            <div class="row">
                                <div class="form-group col-lg-6 fileSourceBlock" style="display: none">
                                    <label for="fileSource"><?=Language::show('fileSource', 'keywords');?></label>
                                    <input type="text" class="form-control" name="fileSource" id="fileSource" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('fileSource', 'keywords');?>" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 dbPortBlock" style="display: none">
                                    <label for="dbPort"><?=Language::show('dbPort', 'keywords');?></label>
                                    <input type="number" class="form-control" name="dbPort" id="dbPort" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('dbPort', 'keywords');?>" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 dbUserNameBlock" style="display: none">
                                    <label for="dbUserName"><?=Language::show('dbUserName', 'keywords');?></label>
                                    <input type="text" class="form-control" name="dbUserName" id="dbUserName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('dbUserName', 'keywords');?>" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 dbPasswordBlock" style="display: none">
                                    <label for="dbPassword"><?=Language::show('dbPassword', 'keywords');?></label>
                                    <input type="password" class="form-control" name="dbPassword" id="dbPassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('dbPassword', 'keywords');?>" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" style="margin-right: 10px;" class="containerSave btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                        Form::close();
                        ?>
                    </div>
                </div>
            </div>
            <div class="modal fade editContainer" tabindex="-1" role="dialog">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <?=
                        Form::open(array(
                            'ng-submit' => 'saveEditedContainerPolicyDetails()',
                            'method' => 'post',
                            'class' => 'attachContainerEditForm',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Edit Container</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-lg-6 hide">
                                    <label for="action"><?=Language::show('deviceUUID', 'keywords');?></label>
                                    <input type="text" value="edit" class="form-control" name="action" id="action" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('action', 'keywords');?>" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 hide">
                                    <label for="deviceUUID"><?=Language::show('deviceUUID', 'keywords');?></label>
                                    <input type="text" value="<?=$data['deviceUUID']?>" class="form-control" name="deviceUUID" id="deviceUUID" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('deviceUUID', 'keywords');?>" required autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="containerName"><?=Language::show('containerName', 'keywords');?></label>
                                    <input type="text" class="form-control" name="editContainerName" id="containerName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('containerName', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="containerType"><?=Language::show('containerType', 'keywords');?></label>
                                    <select class="form-control editContainerType" name="editContainerType" id="editContainerType" required disabled="true">
                                        <?php if(!empty(CONTAINER_TYPES)){ ?>
                                            <option selected disabled>Please Select a container Type</option>
                                            <?php foreach(explode(',', CONTAINER_TYPES) as $key => $value){ ?>
                                                <option value="<?=str_replace(' ', '', strtolower($value))?>"><?=$value?></option>
                                            <?php } ?>
                                        <?php }else{ ?>
                                            <option selected disabled>Please define database types</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-lg-6">
                                    <label for="containerPolicy"><?=Language::show('containerPolicy', 'keywords');?></label>
                                    <select class="selectpicker form-control" name="editContainerPolicy" id="containerPolicy" required>
                                        <?php if(!empty($data['policies'])){ ?>
                                            <?php foreach($data['policies'] as $key => $value){ ?>
                                                <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } else{ ?>
                                            <option selected disabled>Please create a policy</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="userGroup"><?=Language::show('userGroup', 'keywords');?></label>
                                    <select class="selectpicker form-control" name="editUserGroup" id="userGroup" required>
                                        <?php if(!empty($data['groups'])){ ?>
                                            <option selected disabled>Please Select a group</option>
                                            <?php foreach($data['groups'] as $key => $value){ ?>
                                                <option value="<?=str_replace(' ', '', strtolower($value->name))?>"><?=$value->name?></option>
                                            <?php } ?>
                                        <?php }else{ ?>
                                            <option selected disabled>Please create a group</option>
                                            <option value="example">Example</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-lg-6 editFileSourceBlock" style="display: none">
                                    <label for="fileSource"><?=Language::show('fileSource', 'keywords');?></label>
                                    <input type="text" class="form-control" name="editFileSource" id="fileSource" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('fileSource', 'keywords');?>" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 editDbPortBlock" style="display: none">
                                    <label for="dbPort"><?=Language::show('dbPort', 'keywords');?></label>
                                    <input type="number" class="form-control" name="editDbPort" id="dbPort" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('dbPort', 'keywords');?>" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 editDbUserNameBlock" style="display: none">
                                    <label for="dbUserName"><?=Language::show('dbUserName', 'keywords');?></label>
                                    <input type="text" class="form-control" name="editDbUserName" id="dbUserName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('dbUserName', 'keywords');?>" autocomplete="off">
                                </div>
                                <div class="form-group col-lg-6 editDbPasswordBlock" style="display: none">
                                    <label for="dbPassword"><?=Language::show('dbPassword', 'keywords');?></label>
                                    <input type="password" class="form-control" name="editDbPassword" id="dbPassword" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('dbPassword', 'keywords');?>" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" style="margin-right: 10px;" class="containerSave btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                        Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ServerController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.containerType').selectpicker('render').on('change', function(){
        if($('.containerType').val() == 'flatfiles'){
            $('.fileSourceBlock').show();
            $('.dbPasswordBlock').hide();
            $('.dbPassword').val("");
            $('.dbUserNameBlock').hide();
            $('.dbUserName').val("");
            $('.dbPortBlock').hide();
            $('.dbPort').val("");
        }else{
            if($('.containerType').val() == 'mongodb' || $('.containerType').val() == 'oracle' || $('.containerType').val() == 'mssql'){
                $('.fileSourceBlock').show();
            }else{
                $('.fileSourceBlock').hide();
                $('.fileSource').val("");
            }
            $('.dbPasswordBlock').show();
            $('.dbUserNameBlock').show();
            $('.dbPortBlock').show();
        }
    });
    $('.editContainerType').selectpicker('render').on('change', function(){
        console.log($('.editContainerType').val())
        if($('.editContainerType').val() == 'flatfiles'){
            $('.editFileSourceBlock').show();
            $('.editDbPasswordBlock').hide();
            $('.editDbPassword').val("");
            $('.editDbUserNameBlock').hide();
            $('.editDbUserName').val("");
            $('.editDbPortBlock').hide();
            $('.editDbPort').val("");
        }else{
            if($('.editContainerType').val() == 'mongodb' || $('.editContainerType').val() == 'oracle' || $('.editContainerType').val() == 'mssql'){
                $('.editFileSourceBlock').show();
            }else{
                $('.editFileSourceBlock').hide();
                $('.editFileSource').val("");
            }
            $('.editDbPasswordBlock').show();
            $('.editDbUserNameBlock').show();
            $('.editDbPortBlock').show();
        }
    });
</script>
