<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('cloudInfo')?>"><?=Language::show('Dashboard', 'report')?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-12 col-md-12 col-sm-12 ng-cloak">
            <?php if(!empty($_SESSION['OverReportResult'])){ ?>
                <?php if($_SESSION['OverReportResult'] == 404){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 404</span>
                <?php }elseif($_SESSION['OverReportResult'] == 500){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 500</span>
                <?php } ?>
                <?php $_SESSION['OverReportResult'] = ''; ?>
            <?php } ?>
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='overview'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h3>Backup Statistics
                            <span class="overviewJobTime" ng-if="overviewJobTime.length > 0" style="font-size: 14px; display: none;">- SnapShot Timestamp: {{ overviewJobTime }}</span>
                            <a class="pull-right" href="<?=Url::basePath('report/download/overviewReport?from=overview')?>">Download Excel SnapShot</a>
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="searchUserInOverView(search.userName)">
                                    <select name="searchUsername"
                                            style="width: 80%;"
                                           class="pull-right form-control searchUsername"
                                           ng-model="search.userName"
                                           placeholder="Enter a 'username' and hit enter to search"
                                           data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                           data-content="Entered username was not found!!! "></select>
                                    <button type="submit" class="btn tbn-default">Generate</button>
                                    <a onclick="window.location.reload(true)" class="btn tbn-default">Show All</a>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center">Loading.....</div>
                        <table class="table-bordered overviewListTable" style="display: none;">
                            <thead>
                                <tr>
                                    <th class="text-center clickAble" ng-click="overviewSortType = 'userId'; sortReverse = !sortReverse">
                                        <?=Language::show('userId', 'keywords')?>
                                        <span ng-show="overviewSortType == 'userId' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="overviewSortType == 'userId' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="overviewSortType = 'emailId'; sortReverse = !sortReverse">
                                        <?=Language::show('email_address', 'keywords')?>
                                        <span ng-show="overviewSortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="overviewSortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="overviewSortType = 'policyName'; sortReverse = !sortReverse">
                                        <?=Language::show('policyName', 'keywords')?>
                                        <span ng-show="overviewSortType == 'policyName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="overviewSortType == 'policyName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="overviewSortType = 'userActive'; sortReverse = !sortReverse">
                                        <?=Language::show('User Active', 'keywords')?>
                                        <span ng-show="overviewSortType == 'userActive' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="overviewSortType == 'userActive' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="overviewSortType = 'lastLoginTime'; sortReverse = !sortReverse">
                                        <?=Language::show('Last Login Time', 'keywords')?>
                                        <span ng-show="overviewSortType == 'lastLoginTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="overviewSortType == 'lastLoginTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in overview | orderBy:overviewSortType:sortReverse" class="text-center">
                                    <td class="text-center" ng-cloak>{{ value.userId }}</td>
                                    <td ng-cloak>{{ value.emailId }}</td>
                                    <td ng-cloak>{{ value.policyName }}</td>
                                    <td ng-cloak>{{ value.userActive }}</td>
                                    <td ng-cloak>{{ value.lastLoginTime }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'overview')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>


    $('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserName",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>