<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='policy'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=$data['crumb1']?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/policy/create')?>"><?=Language::show('create_new_policy', 'keywords');?></a></span></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-6">
                                    <col class="col-xs-1">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th><?=Language::show('policyName', 'keywords')?></th>
                                        <th><?=Language::show('maxVersions', 'keywords')?></th>
                                        <th><?=Language::show('scheduleNames', 'keywords')?></th>
                                        <th><?=Language::show('action', 'keywords')?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in policies track by $index">
                                        <td ng-cloak>{{ value.policygroupName }}</td>
                                        <td ng-cloak ng-if="value.maxVersions > 0">{{ value.maxVersions }}</td>
                                        <td ng-cloak ng-if="value.maxVersions < 0">unlimited</td>
                                        <td ng-cloak>{{ value.scheduleNames.join(', ') }}</td>
                                        <td><a href="<?=Url::basePath('pms/policy/edit/{{value.policygroupName}}')?>" class="btn btn-default btn-small">Edit</a></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>