<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/networkThrottling')?>"><?=$data['crumb1']?></a></li>
                <li><?=$data['selectedPG']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='networkThrottlingView'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <?php if(!empty($data['pgList'])){ ?>
            <?php
                foreach($data['pgList'] as $key => $value){
                    if($data['selectedPG'] == $value->{'gatewayName'}){
                        $selectedPG = $data['selectedPG'];
                    }
                }
            ?>
            <?php if(!empty($selectedPG)){ ?>
                <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                    <div class="panel">
                        <div class="panel-heading">
                            <?php if($data['type'] == 'c2p') {?>
                                <h4><?=Language::show('clientToBluKrypt', 'keywords')?></h4>
                            <?php }else{ ?>
                                <h4><?=Language::show('bluKryptToAzureBlob', 'keywords')?></h4>
                            <?php } ?>
                        </div>
                        <div class="panel-body">
                            <?php if($data['exists'] == true){ ?>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="panel">
                                            <div class="panel-heading">
                                                <h4><?=Language::show('setThrottlingLimit', 'keywords')?></h4>
                                            </div>
                                            <div class="panel-body">
                                                <?=
                                                Form::open(array(
                                                    'csrf' => $data['csrf_token'],
                                                    'class' => 'throttlingForm form-horizontal',
                                                    'autocomplete' => 'off',
                                                    'ng-submit' => 'setThrottlingLimit()',
                                                    'data-parsley-validate' => true
                                                ));
                                                ?>
                                                <div class="form-group hide">
                                                    <label for="type" class="col-sm-3 control-label"><?=Language::show('type', 'keywords')?></label>
                                                    <div class="col-sm-9">
                                                        <input type="text" class="form-control" name="type" id="type" placeholder="<?=Language::show('type', 'keywords')?>" value="<?=$data['type']?>" required autocomplete="off">
                                                        <input type="text" class="form-control" name="pgName" id="type" placeholder="<?=Language::show('type', 'keywords')?>" value="<?=$data['selectedPG']?>" required autocomplete="off">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="startTime" class="col-sm-3 control-label"><?=Language::show('startTime', 'keywords')?></label>
                                                    <div class="col-sm-9">
                                                        <input type="text" class="form-control timePicker" name="startTime" id="startTime" placeholder="<?=Language::show('startTime', 'keywords')?>" required autocomplete="off">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="endTime" class="col-sm-3 control-label"><?=Language::show('endTime', 'keywords')?></label>
                                                    <div class="col-sm-9">
                                                        <input type="text" class="form-control timePicker" name="endTime" id="endTime" placeholder="<?=Language::show('startTime', 'keywords')?>" required autocomplete="off">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label for="speed" class="col-sm-3 control-label"><?=Language::show('speed', 'keywords')?></label>
                                                    <div class="col-sm-9">
                                                        <input type="text" class="form-control" id="speed" name="uploadSpeed" placeholder="<?=Language::show('speedInMBPS', 'keywords')?>" required autocomplete="off" data-parsley-type="integer"  data-parsley-min="1" />
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <div class="col-sm-12">
                                                        <button type="submit" class="pull-right btn btn-success">Save</button>
                                                    </div>
                                                </div>
                                                <?=Form::close()?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="panel">
                                            <div class="panel-heading">
                                                <h4><?=Language::show('throttlingLimitList', 'keywords')?></h4>
                                            </div>
                                            <div class="panel-body">
                                                <?php if($data['type'] == 'c2p'){ ?>
                                                    <?php if(!empty($data['c2p'])){ ?>
                                                        <table class="table table-bordered table-hover">
                                                            <tbody>
                                                            <tr>
                                                                <th>Start Time</th>
                                                                <th>End Time</th>
                                                                <th>Speed</th>
                                                            </tr>
                                                            <?php foreach($data['c2p'] as $key => $value){ ?>
                                                                <tr>
                                                                    <td><?=$value['startTime']?></td>
                                                                    <td><?=$value['endTime']?></td>
                                                                    <td><?=$value['uploadSpeed']?> Mbps
                                                                        <a href="javascript:;" ng-click="removeThrottlingLimit('<?=$value['id']?>')">
                                                                            <span class="btn-xs btn-danger pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Remove"><i class="fa fa-trash"></i></span>
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                            <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    <?php }else{ ?>
                                                        <h4 class="text-center">There are no Throttling limits set</h4>
                                                    <?php } ?>
                                                <?php }elseif($data['type'] == 'p2a'){ ?>
                                                    <?php if(!empty($data['p2a'])){ ?>
                                                        <table class="table table-bordered table-hover">
                                                            <tbody>
                                                            <tr>
                                                                <th>Start Time</th>
                                                                <th>End Time</th>
                                                                <th>Speed</th>
                                                            </tr>
                                                            <?php foreach($data['p2a'] as $key => $value){ ?>
                                                                <tr>
                                                                    <td><?=$value['startTime']?></td>
                                                                    <td><?=$value['endTime']?></td>
                                                                    <td><?=$value['uploadSpeed']?> Mbps
                                                                        <a href="javascript:;" ng-click="removeThrottlingLimit('<?=$value['id']?>')">
                                                                            <span class="btn-xs btn-danger pull-right toolTip" data-toggle="tooltip" data-placement="bottom" title="Remove"><i class="fa fa-trash"></i></span>
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                            <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    <?php }else{ ?>
                                                        <h4 class="text-center">There are no Throttling limits set</h4>
                                                    <?php } ?>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php }else{ ?>
                                <div class="row">
                                    <h4>Selected Privacy Gateway was not found</h4>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php }else{ ?>
                <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                    <div class="panel">
                        <div class="panel-body">
                            <h2>Selected PG does not exists</h2>
                        </div>
                    </div>
                </div>
            <?php } ?>
        <?php }else{ ?>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-body">
                        <h2>There are no Privacy Gateways defined</h2>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>