<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Form;
use Helpers\Url; ?>

<div class="container">
    <div class="row">

    </div>
    <br/>
    <div class="row">
        <div class="col-lg-6 col-lg-offset-3">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading" style="padding: 30px 30px 10px 30px;">
                    <a><b class="h3"><?=$data['title'];?></b> - <?=Language::show('enter_your', 'keywords');?> <?=Language::show('userNameOrEmailId', 'keywords');?></a>
                </div>
                <div class="panel-body">
                    <div id="status" style="display: none; margin-bottom: 10px;"></div>
                    <?=
                        Form::open(array(
                            'action' => Url::basePath('passwordRest'),
                            'method' => 'post',
                            'class' => 'passwordRest',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                    ?>
                        <div class="form-group">
                            <label for="cloudName"><?=Language::show('cloudName', 'keywords');?></label>
                            <input type="text" name="cloudName" class="form-control" id="cloudName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('cloudName', 'keywords');?>" value="<?=CLOUD_NAME?>" required>
                        </div>
                        <div class="form-group">
                            <label for="userName"><?=Language::show('userNameOrEmailId', 'keywords');?></label>
                            <input type="text" name="userName" class="form-control" id="userName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('userNameOrEmailId', 'keywords');?>" minlength="3" maxlength="104" required>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <?=URL::link('login', Language::show('go_backup', 'keywords'))?>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary pull-right submit"><?=Language::show('submit', 'keywords');?></button>
                    <?=
                        Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
