/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('TrashController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = true;
    $scope.sortType = 'type';

    $scope.items = [];

    $scope.selected = [];

    $scope.updateFileList = function(filePath, currentPath, update, refreshed){
        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/trash',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                disableButtons();
                $('.filePanel').show();
                $scope.items = jData.items;
                $scope.$apply();
                if($scope.items.length <= 0){
                    $('.status').show();
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.selectionStart = function(selected){
        $scope.selected = [];
    };

    $scope.selectionStop = function(selected){
        disableButtons();
        $scope.selected = selected;
        if(selected.length > 0){
            enableButtons();
        }
    };

    function disableButtons(){
        $('.purge').hide();
        $('.restore').hide();
    }

    function enableButtons(){

        if($scope.selected.length > 0){
            $('.purge').show();
            $('.restore').show();
        }

    }

    $scope.menuOptions = [
        ['Purge', function ($itemScope) {
            $scope.confirmPurge();
        }, function(){
            if($scope.selected.length > 0){
                return true;
            }
        }],
        ['Restore', function ($itemScope) {
            $scope.confirmRestore();
        }, function(){
            if($scope.selected.length > 0){
                return true;
            }
        }],
        ['Purge All', function ($itemScope) {
            $scope.confirmPurgeAll();
        }],
        ['Restore All', function ($itemScope) {
            $scope.confirmRestoreAll('');
        }]
    ];

    $scope.confirmPurge = function(){
        $('.confirmPurge').modal('show');
    };

    $scope.confirmRestore = function(){
        $('.confirmRestore').modal('show');
    };

    $scope.confirmPurgeAll = function(){
        $('.confirmPurgeAll').modal('show');
    };

    $scope.confirmRestoreAll = function(){
        $('.confirmRestoreAll').modal('show');
    };

    $scope.purgeFile = function(){
        $('.confirmPurge').modal('hide');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        setTimeout(function(){
            if($scope.selected.length > 0 ){
                var pathsToDelete = [];
                $scope.selected.forEach(function(value, key){
                    pathsToDelete.push(getPath(value))
                });

                $.ajax({
                    url: $scope.BASE_FOLDER+'/trash/purgeFile',
                    type: 'POST',
                    data: {pathsToDelete: pathsToDelete, csrf_token: $('.csrf_token').html()}
                }).done(function(data){
                    myBlockUI.stop();
                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                        $scope.updateFileList('root', 'root', true, true);
                        toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    }else{
                        toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    }

                }).fail(function(data){
                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                    if(data.status == 424){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/sleep';
                        }, 3000);
                    }else if(503){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                        }, 3000);
                    }
                });
            }
        }, 1000);
    };

    $scope.restoreFile = function(){
        $('.confirmRestore').modal('hide');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        setTimeout(function(){
            if($scope.selected.length > 0 ){
                var pathsToDelete = [];
                $scope.selected.forEach(function(value, key){
                    pathsToDelete.push(getPath(value))
                });

                $.ajax({
                    url: $scope.BASE_FOLDER+'/trash/restoreFile',
                    type: 'POST',
                    data: {pathsToDelete: pathsToDelete, csrf_token: $('.csrf_token').html()}
                }).done(function(data){
                    myBlockUI.stop();
                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                        $scope.updateFileList('root', 'root', true, true);
                        toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    }else{
                        toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                    }
                }).fail(function(data){
                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                    if(data.status == 424){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/sleep';
                        }, 3000);
                    }else if(503){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                        }, 3000);
                    }
                });
            }
        }, 1000);

    };

    $scope.restoreAll = function(){

        $('.confirmRestoreAll').modal('hide');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        setTimeout(function(){
            $.ajax({
                url: $scope.BASE_FOLDER+'/trash/restoreAll',
                type: 'POST',
                data: {csrf_token: $('.csrf_token').html()}
            }).done(function(data){
                myBlockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.items = [];
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('.status').show();
                }else if(jData.result == 'notNow'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }, 1000);
    };

    $scope.purgeAll = function(){
        $('.confirmPurgeAll').modal('hide');
        setTimeout(function(){
            var myBlockUI = blockUI.instances.get('myBlockUI');
            myBlockUI.start();

            $.ajax({
                url: $scope.BASE_FOLDER+'/trash/purgeAll',
                type: 'POST',
                data: {csrf_token: $('.csrf_token').html()}
            }).done(function(data){
                myBlockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.items = [];
                    $scope.$apply();
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('.status').show();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }, 2000);

    };

    function getPath(value){
        return value.filePath+'/'+value.fileName;
    }


    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'trash'){
            blockUI.start();
            $scope.updateFileList('root', 'root', true, true);
        }

    });

}]);
