/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ShareController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.sortReverse = true;
    $scope.sortType = 'type';

    $scope.items = [];

    $scope.selected = [];

    $scope.updateFileList = function(filePath, currentPath, update, refreshed){
        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/share/myShares',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html()}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                disableButtons();
                $('.filePanel').show();
                $scope.items = jData.items;
                $scope.$apply();
                toastr.info('Page loaded successfully', 'Information!!!', {allowHtml: true});
                if($scope.items.length <= 0){
                    $('.status').show();
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.selectionStart = function(selected){
        $scope.selected = [];
    };

    $scope.selectionStop = function(selected){
        disableButtons();
        $scope.selected = selected;
        if(selected.length == 1){
            enableButtons();
        }
    };

    function disableButtons(){
        $('.getLink').hide();
        $('.unShare').hide();
        $('.openFile').hide();
    }

    function enableButtons(){

        if($scope.selected.length > 0){
            $('.getLink').show();
            $('.unShare').show();
            $('.openFile').show();
        }

    }

    $scope.menuOptions = [
        ['Get Link', function ($itemScope) {
            $scope.getLink();
        }, function(){
            if($('.shareType').html() != 'shareWith'){
                if($scope.selected.length == 1){
                    return true;
                }
            }
        }],
        ['Un-Share', function ($itemScope) {
            $scope.unShareFile();
        }, function(){
                if($scope.selected.length == 1) {
                    return true;
                }
        }],
        ['Open File Location', function ($itemScope) {
            $scope.openFile();
        }, function(){
            if($scope.selected.length == 1){
                return true;
            }
        }],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                return true;
            }
        }]
    ];

    $scope.getLink = function(){
        $('#share').modal('show');
        var data = {
            fileName : $scope.selected[0].fileName,
            filePath : $scope.selected[0].devicePath
        };
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/files/isShareCheck',
            type: 'POST',
            data: data
        }).done(function(data){
            $('.shareLoading').hide();
            $('.shareBody').show();
            var jData = JSON.parse(data);
            $scope.sharedFileDetails = jData.data;
            if(jData.result == true){
                $('.unShareBtn').show();
                $('.shareLinkBlock').show();
                $('.shareLink').html(jData.link);
            }else{
                $('#share').modal('hide');
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.openFile = function(){
        if($scope.selected[0].backupID.length > 0){
            window.location.href = $scope.BASE_FOLDER+'/backup/openFileLocation?filePath='+$scope.selected[0].devicePath+"&deviceID="+$scope.selected[0].deviceID+"&deviceUUID="+$scope.selected[0].deviceUUID+"&deviceName="+$scope.selected[0].deviceName;
        }else{
            window.location.href = $scope.BASE_FOLDER+'/openFileLocation?filePath='+$scope.selected[0].devicePath;
        }
    };

    $scope.unShareFile = function(){
        var url = "";
        var data = {};
        if($scope.selected[0].backupID.length > 0){
            url = $scope.BASE_FOLDER+'/backup/files/unShare';
            data = {
                fileName : $scope.selected[0].fileName,
                filePath : $scope.selected[0].devicePath,
                csrf_token : $('.csrf_token').html(),
                backupID : $scope.selected[0].backupID
            };
        }else{
            url = $scope.BASE_FOLDER+'/sync/files/unShare';
            data = {
                fileName : $scope.selected[0].fileName,
                filePath : $scope.selected[0].devicePath
            };
        }
        $.ajax({
            url: url,
            type: 'POST',
            data: data
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result = 'success'){
                $('#share').modal('hide');
                $('#shareWith').modal('hide');
                $scope.updateFileList('root', 'root', true, true);
                toastr.success('File has been successfully unshared', 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };
    
    $scope.copyToClipboard = function(){
        toastr.success('Copied to Clipboard');
    };
    
    $scope.sendEmailShareLink = function(){
        $('.sendEmailShareForm').toggleClass('hide');
    };
    
    $scope.sendShareEmail = function(emails){
        if(emails != undefined && emails.length > 0){
            $('.loading').show();
            var html = $('.shareEmailLinkSendBtn').html();
            $('.shareEmailLinkSendBtn').attr('disabled','disabled');
            $('.shareEmailLinkSendBtn').html('Sending... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/sendShareEmail',
                data: {emails: emails, url: $('.shareLink').html(), fileName: $scope.selected[0].fileName, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                $('.shareEmailLinkSendBtn').removeAttr('disabled');
                $('.shareEmailLinkSendBtn').html(html);
                if(jData.result == 'success'){
                    $('.sendEmailShareForm').addClass('hide');
                    $('#emails').val('');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>email address</b>', 'Fail!!!', {allowHtml: true});
        }
    };
    
    $('#share').on('hidden.bs.modal', function () {
        $(this).removeData('bs.modal');
        $('.shareLoading').show();
        $('.shareBody').hide();
        $('.shareLinkBlock').hide();
        $('.shareBtn').hide();
        $('.unShareBtn').hide();
        $('.updateShareDetails').hide();
    });

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'trash'){
            blockUI.start();
            $scope.updateFileList('root', 'root', true, true);
        }

    });

}]);
