/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('ServerController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'timeAgo', function($scope, toastr, Upload, $http, $ngBootbox, blockUI, BASE_FOLDER, timeAgo) {

    timeAgo.settings.fullDateAfterSeconds = 60*60*24;

    $scope.sortReverse = true;
    $scope.sortType = '';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.selectedUser = $('.selectedUser').html();
    $scope.devices = [];
    $scope.items = [];

    $scope.selected = [];
    $scope.crumb = [];
    $scope.fileVersions = [];
    $scope.crumbString = '';
    $scope.currentCrumb = '';
    $scope.skipValue = 0;

    $scope.selectedFileList = [];
    $scope.selectedServerForAction = '';
    $scope.selectedFileForRestoreList = [];
    $scope.selectedFilesForRestore = [];
    $scope.selectedFilesForRestoreFromVersions = [];
    $scope.selectedContainerName = '';

    $scope.containerBasePath = '';
    $scope.selectedContainer = '';

    $scope.backupOptions = {
        full: {
            label: "Full Backup",
            className: "btn-primary fullBackupBtn",
            callback: function() {
                $scope.initiateBackup('full');
            }
        },
        incremental: {
            label: "Incremental Backup!",
            className: "btn-success incrementalBackupBtn",
            callback: function() {
                $scope.initiateBackup('incremental');
            }
        }
    };


    $scope.markAsSelectedServerForAction = function(serverHostName, selectedContainerName){
        $scope.selectedServerForAction = serverHostName;
        $scope.selectedContainerName = selectedContainerName;
        $scope.$apply();
    };

    $scope.updateDevices = function(deviceName, skipValue){
        if(skipValue == 0){
            $scope.devices = [];
        }
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/servers',
            data: {deviceName: deviceName, skipValue: skipValue, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.deviceListTable').show();
                if(deviceName == 'all'){
                    if(jData.devices.length > 0){
                        $scope.skipValue = $scope.skipValue+1;
                        jData.devices.forEach(function($value){
                            $scope.devices.push($value);
                        });
                        if($scope.devices.length < 1000){
                            //$scope.updateDevices(deviceName, $scope.skipValue);
                        }
                        $scope.$apply();
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').hide();
                        $('.loadMore').hide();
                    }else{
                        $('.loadMore').hide();
                    }
                }else{
                    if(jData.devices.length > 0){
                        $scope.devices = jData.devices;
                        $scope.$apply();
                        $('.loadMore').hide();
                    }else{
                        $('.loading').hide();
                        $('[name="searchUsername"]').popover('show');
                    }
                }
            }else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
                $('.loadMoreBtn').removeAttr('disabled');
                $('.loadMoreBtn').html('Load More ...');
                $('.loadMoreBtn').show();
                $('.loadMore').hide();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchDevice = function(serverName){
        $('[name="serverName"]').popover('hide');
        $('.loading').html('Loading ...');
        if(serverName.length == 0){
            serverName = 'all';
        }
        $scope.updateDevices(serverName, 0);
    };

    $scope.initiateBackup = function(type){
        var html;
        if(type == 'full'){
            html = disableBTN($('.fullBackupBtn'));
        }else{
            html = disableBTN($('.incrementalBackupBtn'));
        }
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/initiateBackup',
            data: {csrf_token: $('.csrf_token').html(), serverHostName: $scope.selectedServerForAction, selectedContainerName: $scope.selectedContainerName, type: type},
            type: 'POST'
        }).done(function(data){
            if(type == 'full'){
                html = enableBTN($('.fullBackupBtn'));
            }else{
                html = enableBTN($('.incrementalBackupBtn'));
            }
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function disableBTN(selectedBTN){
        var html = selectedBTN.html();
        selectedBTN.attr('disabled','disabled');
        selectedBTN.html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        return html;
    }

    function enableBTN(selectedBTN, html){
        selectedBTN.removeAttr('disabled');
        selectedBTN.html(html);
    }

    $scope.refreshPolicy = function(serverHostName, key){
        var html = disableBTN($('.refreshPolicyBTN'+key));
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/initiateRefreshPolicy',
            data: {csrf_token: $('.csrf_token').html(), serverHostName: serverHostName},
            type: 'POST'
        }).done(function(data){
            enableBTN($('.refreshPolicyBTN'+key), html);
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.decoupleAgent = function(serverHostName, key){
        var html = disableBTN($('.decoupleAgent'+key));
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/decoupleAgent',
            data: {csrf_token: $('.csrf_token').html(), serverHostName: serverHostName},
            type: 'POST'
        }).done(function(data){
            enableBTN($('.decoupleAgent'+key), html);
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.terminateServerJob = function(containerName, serverHostName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/terminateServerJob',
            data: {csrf_token: $('.csrf_token').html(), containerName: containerName, serverHostName: serverHostName},
            type: 'POST'
        }).done(function(data){

            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }

        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFileList = function(filePath, currentPath, update, refreshed, index){

        if(filePath == $scope.crumbString){
            return false;
        }
        if(refreshed != true){
            refreshed = false;
        }
        filePath = filePath.replace(/\/$/, '');
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $scope.selected = [];
        if(filePath == 'root'){
            $scope.crumb = [];
            $scope.crumbString = '';
            $scope.currentCrumb = '';
        }
        $('.status').hide();
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/files',
            type: 'POST',
            data: {csrf_token: $('.csrf_token').html(), filePath: htmlspecialchars_decode(filePath), refresh: refreshed, containerName: $('.containerName').html()}
        }).done(function(data){
            $('#selectable tr').removeClass('ui-selected');
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success') {
                $('.addBtn').hide();
                if (jData.items.length > 0) {
                    checkBreadCrumb();
                    $('.filePanel').show();
                    if (filePath != 'root') {
                        $scope.currentCrumb = currentPath;
                        if (update == true) {
                            $scope.crumb.push(currentPath);
                        }
                        $scope.crumbString = filePath + '/';
                        if($scope.crumb.length == 1){
                            if($scope.items[index] != undefined){
                                $scope.containerBasePath = $scope.items[index].filePath
                            }
                        }
                    } else {
                        if (refreshed == true) {
                            if (jData.crumb && jData.crumbString) {
                                $scope.crumb = jData.crumb;
                                $scope.crumbString = jData.crumbString + '/';
                                $scope.$apply();
                            }
                        }
                    }
                    $scope.items = jData.items.sort(compare);
                    $scope.$apply();
                } else {
                    if (filePath == 'root') {
                        $scope.$apply();
                        toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
                        setTimeout(function () {
                            window.location.href = $scope.BASE_FOLDER+'/server/attachContainer/'+$('.currentDeviceName').html()+'/'+$('.deviceUUID').html();
                        }, 3000)
                    } else {
                        $scope.$apply();
                        toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside!!!', 'Fail!!!', {allowHtml: true});
                    }
                }
            }else{
                toastr.error('There are no <b>Files</b> nor <b>Folders</b> inside, Redirecting you back', 'Fail!!!', {allowHtml: true});
                setTimeout(function () {
                    window.location.href = $scope.BASE_FOLDER+'/server/attachContainer/'+$('.currentDeviceName').html()+'/'+$('.deviceUUID').html();
                }, 3000)
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateFileListFromBreadCrumb = function(currentPath, key){
        var filePath = '';
        var crumb = [];
        for(var i = 0; i <= key; i++){
            filePath = filePath+$scope.crumb[i]+'/';
            crumb.push($scope.crumb[i]);
        }
        if(filePath != ''){
            $scope.crumb = crumb;
            $scope.updateFileList($scope.containerBasePath+'/'+filePath, currentPath, false, 'root');
        }else{
            $scope.updateFileList('root', 'root', true, 'root');
        }
    };

    function compare(a,b) {
        if (a.type > b.type)
            return -1;
        if (a.type < b.type)
            return 1;
        return 0;
    }

    function getKey(arr,val) {
        for (var i=0; i<arr.length; i++)
            if (arr[i] === val)
                return i;
        return 0;
    }

    function checkBreadCrumb(){
        var element = document.getElementById('breadCrumb');
        var lis = $("ul.nav-breadcrumb li");
        var i = 0;
        if (element.offsetWidth > 700) {
            for(i = 0; i < lis.length; i++){
                if(i > 1){
                    lis[i].childNodes[0].innerHTML = '...';
                }
            }
        }else{
            for(i = 0; i < lis.length; i++){
                if(i > 1){
                    if(lis[i].childNodes[0].innerHTML == '...'){
                        if($scope.crumb[i] != undefined){
                            lis[i].childNodes[0].innerHTML = $scope.crumb[i];
                        }else{
                            lis[i].remove();
                        }
                    }
                }
            }
        }
    }

    $scope.updateUserDevices = function(username){
        $('.loading').html('Loading ...');
        if(username){
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/devices',
                data: {csrf_token: $('.csrf_token').html(), userName: username},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.devices.length > 0){
                        $('.status').hide();
                        $('.devicesList').show();
                        $scope.devices = jData.devices;
                        $scope.$apply();
                    }else{
                        $('.listOfDevices').html('<a style="color: #585f69;">You have not configured any devices yet to be backed up!!!</a>');
                        toastr.info('You have not configured any devices yet to be backed up!!!', 'Information!!!', {allowHtml: true});
                    }
                }else{
                    $('.devicesList').hide();
                    $('.status').show();
                    $('.status').html('<h4>No Devices has been configured yet</h4>');
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.openFilesPage = function(deviceId, deviceName){
        window.location.href = $scope.BASE_FOLDER+'/backup/files/'+deviceId+'/'+deviceName;
    };

    $scope.selectionStart = function(selected){
        $('.contextMenu').hide();
    };

    $scope.selectionStop = function(selected){
        $scope.selected = selected;
        if(selected.length >= 1){
            $('.addBtn').show();
            if($scope.selected[0].type == "File"){
                if($('.selectedContainerType').html() == 'flatfiles'){
                    $('.versionsBtn').show();
                }
            }
        }else{
            $('.addBtn').hide();
            $('.versionsBtn').hide();
        }
    };

    $scope.menuOptions = [
        ['Open', function ($itemScope) {
            $scope.updateFileList($scope.selected[0].fullPath, $scope.selected[0].name, true, 'root');
        }, function(){
            if($scope.selected.length == 1){
                if($scope.selected[0].type === 'Folder'){
                    return true;
                }
            }
        }],
        ['Add To Restore', function ($itemScope) {
            $scope.addToRestoreBackup();
        }, function(){
            if($scope.selected.length >= 1){
                if($('.userType').html() != 'readOnlyAdmin'){
                    return true;
                }
            }
        }],
        ['Add all versions to restore', function () {
            if($scope.addVersionsToRestore()){
                $scope.addToRestoreBackup(true);
            }
        }, function(){
            if($scope.selected.length >= 1){
                if($('.userType').html() != 'readOnlyAdmin') {
                    if($scope.selected[0].type == "File"){
                        if($('.selectedContainerType').html() == 'flatfiles'){
                            return true;
                        }
                    }
                }
            }
        }],
        ['Versions', function () {
            $scope.getVersions();
        }, function(){
            if($scope.selected.length < 2){
                if($('.userType').html() != 'readOnlyAdmin'){
                    if($scope.selected[0].type == "File"){
                        if($('.selectedContainerType').html() == 'flatfiles'){
                            return true;
                        }
                    }
                }
            }
        }],
        ['Nothing Selected', function () {

        }, function(){
            if($scope.selected.length < 1){
                return true;
            }
        }]
    ];

    $scope.addVersionsToRestore = function(){
        $scope.selectedFilesForRestoreFromVersions = $scope.selectedFilesForRestoreFromVersions
            .filter(function (el) {
                return el.name !== $scope.selected[0].name;
            });
        toastr.info('Selected file, '+$scope.selected[0].name+' has been added to restore bucket, to initiate the restore click on Initiate Restore');
        return true;
    };

    $scope.addToRestoreBackup = function(restoreAllVersions){
        if($scope.selected.length >= 1){
            $scope.selected.forEach(function(value, key){
                if($scope.selectedFileForRestoreList.length < 1){
                    value.restoreAllVersions = restoreAllVersions;
                    var checkResultVersions = checkIfExists(value, $scope.selectedFilesForRestoreFromVersions);
                    if(checkResultVersions == false){
                        $scope.selectedFileForRestoreList.push(value);
                    }else{
                        toastr.error('Selected item, ' + value.name + ' has already been added to restore');
                    }
                    if(restoreAllVersions == false){
                        toastr.info('Selected item, '+value.name+' has been added to restore bucket, to initiate the restore click on Initiate Restore');
                    }
                }else{
                    var checkResult = checkIfExists(value, $scope.selectedFileForRestoreList);
                    if(checkResult == false){
                        value.restoreAllVersions = restoreAllVersions;
                        $scope.selectedFileForRestoreList.push(value);
                        if(restoreAllVersions == false) {
                            toastr.info('Selected item, ' + value.name + ' has been added to restore bucket, to initiate the restore click on Initiate Restore');
                        }
                    }else if(checkResult == 'parent'){
                        if(restoreAllVersions == false) {
                            toastr.error('Selected item, ' + value.name + '\'s parent folder has already been added to restore');
                        }
                    }else if(checkResult == 'added') {
                        value.restoreAllVersions = restoreAllVersions;
                        $scope.selectedFileForRestoreList = $scope.selectedFilesForRestore;
                        $scope.selectedFileForRestoreList.push(value);
                        if(restoreAllVersions == false) {
                            toastr.info('Items which were selected to restore have been removed as the parent folder, ' + value.name + ' has been added to restore');
                        }
                    }else{
                        if(restoreAllVersions == false) {
                            toastr.error('Selected item, ' + value.name + ' has already been added to restore');
                        }
                    }
                }
            });
        }else{
            toastr.error('No files Selected to restore');
        }
    };

    $scope.addToRestoreBackupFromRevisions = function(key, version){
        var fileElement = {
            name: $scope.selected[0].name,
            fullPath: $scope.selected[0].fullPath,
            size: $scope.fileVersions[key].size,
            serverModifiedTime:$scope.fileVersions[key].serverModifiedTime,
            backupId: $scope.fileVersions[key].backupId,
            user: $scope.fileVersions[key].fileUser,
            version: version
        };
        $scope.selectedFileForRestoreList = $scope.selectedFileForRestoreList
            .filter(function (el) {
                return el.name !== $scope.selected[0].name;
            });

        if($scope.selectedFilesForRestoreFromVersions.length <= 0){
            $scope.selectedFilesForRestoreFromVersions.push(fileElement);
            toastr.info(fileElement.name+', has been added to restore bucket, to initiate the restore click on Initiate Restore');
        }else{
            if(checkIfExistsOrNot(fileElement) == false){
                $scope.selectedFilesForRestoreFromVersions.push(fileElement);
                toastr.info(fileElement.name+', has been added to restore bucket, to initiate the restore click on Initiate Restore');
            }else{
                toastr.error('Selected file, '+fileElement.name+' has already been added to restore');
            }
        }
    };

    function checkIfExistsOrNot(fileElement){
        var result = false;
        $scope.selectedFilesForRestoreFromVersions.forEach(function(value, key){
            if(fileElement.backupId == value.backupId){
                result = true;
            }
        });
        return result;
    }

    $scope.removeFromSelectedItems = function(index){
        if(index >= 0){
            $scope.selectedFileForRestoreList.splice(index, true);
        }else{
            toastr.error('Selected file does not exist');
        }
    };

    $scope.removeFromSelectedItemsVersions = function(index){
        if(index >= 0){
            $scope.selectedFilesForRestoreFromVersions.splice(index, true);
        }else{
            toastr.error('Selected file does not exist');
        }
    };

    function checkIfExists(value, values){
        var exists = false;
        values.forEach(function(existingValue, existingKey){
            if(checkIfExistsInVersions(value.backupId)) {
                exists = true;
            }else if(value.backupId == existingValue.backupId){
                exists = true;
            }else{
                var existingValueArray = existingValue.fullPath.split('/');
                var valueArr = value.fullPath.split('/');
                if(existingValue.fullPath.indexOf(valueArr[0]) == 0){
                    if(valueArr.length == 1){
                        removeChildren(valueArr[0]);
                        exists = 'added';
                    }else if(existingValueArray.length == (valueArr.length+1)){
                        if(existingValueArray[1] == valueArr[1]){
                            removeChildren(valueArr[0]);
                            exists = 'added';
                        }
                    }else if(existingValueArray.length == 1){
                        exists = 'parent';
                    }else if((existingValueArray.length+1) == valueArr.length){
                        var i = 0;
                        var result = true;
                        var valueString = '';
                        var existingValueString = '';
                        while (i < existingValueArray.length) {
                            valueString += valueArr[i];
                            existingValueString += existingValueArray[i];
                            if(valueString != existingValueString){
                                result = false;
                                i = valueArr.length
                            }else{
                                i++;
                            }
                        }
                        if(result){
                            exists = 'parent';
                        }
                    }
                }

            }
        });
        return exists;
    }

    function checkIfExistsInVersions(currentBackupID){
        var result = false;
        $scope.selectedFilesForRestoreFromVersions.forEach(function(value, key){
            if(value.backupId == currentBackupID){
                result = true;
            }
        });
        return result;
    }

    function removeChildren(basePath){
        var filesList = [];
        $scope.selectedFileForRestoreList.forEach(function(file, key){
            if(file.fullPath.indexOf(basePath) != 0){
                filesList.push(file);
            }
        });
        $scope.selectedFilesForRestore = filesList;
    }

    $scope.initiateRestore = function(serverHostName){

        var paths = getFilePaths($scope.selectedFileForRestoreList, $scope.selectedFilesForRestoreFromVersions);
        var restorePath = $('.restorePath').val();
        if(paths.length > 1){
            if(restorePath.length <= 0){
                toastr.error('Please enter a restore Path', 'Fail!!!', {allowHtml: true});
                return;
            }
        }else{
            if(restorePath.length <= 0){
                if($scope.selectedFileForRestoreList[0].filePath.length >= 1){
                    restorePath = $scope.selectedFileForRestoreList[0].filePath;
                }else{
                    toastr.error('You have selected a root folder; so, please enter a restore path', 'Fail!!!', {allowHtml: true});
                    return;
                }
            }
        }

        if($scope.selectedFileForRestoreList.length >= 1){
            var html = $('.initiateRestoreBtn').html();
            $('.initiateRestoreBtn').attr('disabled','disabled');
            $('.initiateRestoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/server/initiateRestore',
                data: {csrf_token: $('.csrf_token').html(), deviceUUID: $('.deviceUUID').html(), containerName: $('.containerName').html(), serverHostName: serverHostName, paths: paths, path: restorePath, timestamp: $('.restoreTimeStamp').val()},
                type: 'POST'
            }).done(function(data){
                $('.initiateRestoreBtn').removeAttr('disabled','disabled');
                $('.initiateRestoreBtn').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('.restorePath').val(null);
                    $scope.selectedFileForRestoreList = [];
                    $scope.$apply();
                    toastr.success('Restore has been triggered, files will be restored in the selected location!!!', 'Information!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }

            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('No Folders has been selected to restore', 'Fail!!!', {allowHtml: true});
        }

    };

    function getFilePaths(files, fileVersions){
        var paths = [];
        files.forEach(function(file, key){
            var filePath;
            if(file.filePath){
                filePath = file.filePath+'/'+file.name
            }else{
                filePath = $scope.crumbString+file.name
            }
            var path = {
                name: file.name,
                path: filePath,
                isFolder: file.type == 'Folder',
                userName: file.user,
                isRestoreAllVersions: file.restoreAllVersions,
                backupId: '',
                version: 0
            };
            paths.push(path);
        });
        fileVersions.forEach(function(filev, keyv){
            var path = {
                name: filev.name,
                path: filev.fullPath,
                isFolder: filev.type == 'Folder',
                userName: filev.user,
                isRestoreAllVersions: 'false',
                backupId: filev.backupId,
                version: filev.version
            };
            paths.push(path);
        });
        return paths;
    }

    $scope.getVersions = function(){
        $('.loading').html('Loading ...');
        if($scope.selected.length == 1){
            $.ajax({
                url: $scope.BASE_FOLDER+'/backup/files/fileVersions',
                data: {csrf_token: $('.csrf_token').html(), fileName: $scope.selected[0].name, filePath: cleanUrl($scope.selected[0].filePath)},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(jData.fileVersions.length > 0){
                        $scope.fileVersions = jData.fileVersions;
                        $scope.$apply();
                        $('.backupFileVersions').modal('show');
                        $('.loading').hide();
                        $('.deviceHistoryDetailsTable').show();
                    }else{
                        $scope.$apply();
                        toastr.error('There is <b>no versions</b> that has been saved for the selected file', 'Fail!!!', {allowHtml: true});
                    }
                }else{
                    $scope.$apply();
                    toastr.error('There is <b>no versions</b> that has been saved for the selected file', 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveNewUserDetails = function(){
        if($('.userCreationFrom').parsley().isValid()) {
            var html = $('.userSave').html();
            $('.userSave').attr('disabled', 'disabled');
            $('.userSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/create',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.userSave').removeAttr('disabled');
                $('.userSave').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('Server has been created successfully', 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/servers';
                    }, 3000)
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveNewContainerPolicyDetails = function(){
        if($('.attachContainerNewForm').parsley().isValid()) {
            var html = $('.containerSave').html();
            $('.containerSave').attr('disabled', 'disabled');
            $('.containerSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/server/createContainer',
                data: $('.attachContainerNewForm').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.containerSave').removeAttr('disabled');
                $('.containerSave').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('Container has been created', 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            console.log('Invalid Form');
        }
    };

    $scope.editContainerDetails = function(index){
        if($scope.containerList[index] != undefined){
            $scope.selectedContainer = index;
            $('[name="editContainerName"]').val($scope.containerList[index].containerName);
            $('[name="editContainerType"]').find('option[value="'+$scope.containerList[index].containerType+'"]').prop("selected",true);
            $('[name="editContainerType"]').selectpicker('render');
            $('[name="editContainerPolicy"]').find('option[value="'+$scope.containerList[index].backupPolicyName+'"]').prop("selected",true);
            $('[name="editContainerPolicy"]').selectpicker('render');
            $('[name="editUserGroup"]').find('option[value="'+$scope.containerList[index].groupName.toLowerCase()+'"]').prop("selected",true);
            $('[name="editUserGroup"]').selectpicker('render');
            if($scope.containerList[index].containerType == 'flatfiles'){
                $('.editFileSourceBlock').show();
                $('[name="editFileSource"]').val($scope.containerList[index].containerLocation);
                $('.editDbPasswordBlock').hide();
                $('.editDbPassword').val("");
                $('.editDbUserNameBlock').hide();
                $('.editDbUserName').val("");
                $('.editDbPortBlock').hide();
                $('.editDbPort').val("");
            }else{
                if($scope.containerList[index].containerType == 'mongodb' || $scope.containerList[index].containerType == 'oracle' || $scope.containerList[index].containerType == 'mssql'){
                    $('.editFileSourceBlock').show();
                    $('[name="editFileSource"]').val($scope.containerList[index].containerLocation);
                }else{
                    $('.editFileSourceBlock').hide();
                    $('.editFileSource').val("");
                }
                $('.editDbPasswordBlock').show();
                $('[name="editDbPassword"]').val($scope.containerList[index].password);
                $('.editDbUserNameBlock').show();
                $('[name="editDbUserName"]').val($scope.containerList[index].username);
                $('.editDbPortBlock').show();
                $('[name="editDbPort"]').val($scope.containerList[index].port);
            }
            $('.editContainer').modal("show");
        }else{
            toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.saveEditedContainerPolicyDetails = function(){
        if($('.attachContainerEditForm').parsley().isValid()) {
            var html = $('.containerSave').html();
            $('.containerSave').attr('disabled', 'disabled');
            $('.containerSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            var data = {
                csrf_token              : $('[name="csrf_token"]').val(),
                backupPolicyName        : $('[name="editContainerPolicy"]').selectpicker('val'),
                containerLocation       : $('[name="editFileSource"]').val(),
                containerName           : $('[name="editContainerName"]').val(),
                containerType           : $('[name="editContainerType"]').selectpicker('val'),
                deviceUUID              : $scope.containerList[$scope.selectedContainer].deviceUUID,
                groupName               : $('[name="editUserGroup"]').selectpicker('val'),
                id                      : $scope.containerList[$scope.selectedContainer].id,
                nextPolicyRefresh       : $scope.containerList[$scope.selectedContainer].nextPolicyRefresh,
                nextScheduledBackup     : $scope.containerList[$scope.selectedContainer].nextScheduledBackup,
                password                : $('[name="editDbPassword"]').val(),
                port                    : $('[name="editDbPort"]').val(),
                username                : $('[name="editDbUserName"]').val()
            };
            $.ajax({
                url: $scope.BASE_FOLDER+'/server/editSaveContainer',
                data: data,
                type: 'POST'
            }).done(function(data){
                $('.containerSave').removeAttr('disabled');
                $('.containerSave').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success('Container details has been updated', 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).fail(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            console.log('Invalid Form');
        }
    };

    $scope.updateContainerList = function(){
        $('.containerListContainer').show();
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/containers',
            data: {deviceUUID: $('[name="deviceUUID"]').val(), csrf_token: $('[name="csrf_token"]').val()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            $('.status').hide();
            $('.containerListContainer').show();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.data == null){
                    $('.status').show();
                    $('.status').html('<h4 align="center">There were no containers found</h4>');
                }else{
                    $scope.containerList = jData.data;
                }
                $scope.$apply();
            }else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
            }
        }).fail(function(data){
            blockUI.stop();
            myBlockUI.stop();
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeContainer = function(key, serverHostName){
        var myBlockUI = blockUI.instances.get('myBlockUI');
        myBlockUI.start();
        var data = $scope.containerList[key];
        data.csrf_token = $('[name="csrf_token"]').val();
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/remove/container',
            data: data,
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            myBlockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success('Container has been successfully deleted', 'Successful!!!', {allowHtml: true});
                $.ajax({
                    url: $scope.BASE_FOLDER+'/server/initiateRefreshPolicy',
                    data: {csrf_token: $('.csrf_token').html(), serverHostName: serverHostName},
                    type: 'POST'
                }).done(function(rData){
                    var RjData = JSON.parse(rData);
                    if(RjData.result == "success"){
                        toastr.success('Policy on the server has been refreshed', 'Successful!!!', {allowHtml: true});
                    }else{
                        toastr.error('Policy on the server was not refreshed', 'Successful!!!', {allowHtml: true});
                    }
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 3000);
                }).fail(function(data){
                    toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                    if(data.status == 424){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/sleep';
                        }, 3000);
                    }else if(data.status == 503){
                        setTimeout(function(){
                            window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                        }, 3000);
                    }
                });
            }else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
            }
        }).fail(function(data){
            blockUI.stop();
            myBlockUI.stop();
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateServerJobs = function(deviceUUID){
        var status = $("#jobStatus").val();
        $scope.serverJobs = [];
        $('.resultStatus').hide();
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/jobs',
            data: {deviceUUID: deviceUUID, status: status, csrf_token: $('.csrf_token').html(), skipValue: $scope.skipValue},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.serverJobs != null){
                    if(jData.serverJobs.length > null) {
                        $scope.serverJobs = jData.serverJobs;
                        $scope.$apply();
                    }else{
                        $('.resultStatus').show();
                        $('.resultStatus').html('There were no jobs found');
                    }
                }else{
                    $('.resultStatus').show();
                    $('.resultStatus').html('There were no jobs found');
                }
            }else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    function cleanUrl(str) {
        if(str.substr(-1) === '/') {
            return str.substr(0, str.length - 1);
        }
        return str;
    }

    function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }

    $scope.blockUnBlockDevice = function(deviceId, action, key){

        $.ajax({
            url: $scope.BASE_FOLDER+'/device/blockUnBlockDevice',
            data: {device: $scope.devices[key], action: action, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                if(action == true){
                    $scope.devices[key].blocked = 'true';
                }else{
                    $scope.devices[key].blocked = 'false';
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');

        if($scope.currentPage == 'restore'){
            $('.backupFilesTable').show();
            blockUI.start();
            $scope.updateFileList('root', 'root', true, true, 'root');
        }

        if($scope.currentPage == 'devices'){
            $scope.updateDevices('all', $scope.skipValue);
        }

        if($scope.currentPage == 'updateContainerList'){
            $scope.updateContainerList('all');
        }

        if($scope.currentPage == 'serverJobs'){
            $scope.updateServerJobs('all', 'running');
        }


        $('body').click(function() {
            $('.contextMenu').hide();
        });

        $('.contextMenu').click(function() {
            $('.contextMenu').hide();
        });
    });

    $scope.setSessionAndSendMeTo = function(location, type){
        $.ajax({
            url: $scope.BASE_FOLDER+'/setSessionForRedirect',
            data: {csrf_token: $('.csrf_token').html(), selectedContainerType: type},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                window.location.href = location;
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                $scope.$apply();
            }
        }).fail(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.sendMeTo = function(location){
        window.location.href = location;
    };

}]);
