/**
 * Created by parablu-dev on 8/5/15.
 */
var app = angular.module('myApp', ['ngAnimate', 'toastr', 'ngFileUpload', 'ngBootbox', 'blockUI', 'ngSelectable', 'ngSanitize', 'ui.select', 'angular-md5', 'ljungmann.fileMd5', 'yTimeAgo']);

app.constant('BASE_FOLDER', '/portal');

app.config(function(toastrConfig, BASE_FOLDER) {
    angular.extend(toastrConfig, {
        allowHtml: false,
        autoDismiss: false,
        closeButton: true,
        closeHtml: '<button>&times;</button>',
        containerId: 'toast-container',
        extendedTimeOut: 1000,
        iconClasses: {
            error: 'toast-error',
            info: 'toast-info',
            success: 'toast-success',
            warning: 'toast-warning'
        },
        maxOpened: 0,
        messageClass: 'toast-message',
        newestOnTop: true,
        onHidden: null,
        onShown: null,
        positionClass: 'toast-bottom-right',
        preventDuplicates: false,
        preventOpenDuplicates: true,
        progressBar: true,
        tapToDismiss: true,
        target: 'body',
        templates: {
            toast: BASE_FOLDER+'/app/templates/default/js/angular/directives/toast/toast.html',
            progressbar: BASE_FOLDER+'/app/templates/default/js/angular/directives/progressbar/progressbar.html'
        },
        timeOut: 5000,
        titleClass: 'toast-title',
        toastClass: 'toast'
    });
});

app.filter('bytes', function() {
    return function(bytes, precision) {
        if (isNaN(parseFloat(bytes)) || !isFinite(bytes) || bytes.length <= 0) return '-';
        if (typeof precision === 'undefined') precision = 1;
        var units = ['bytes', 'kB', 'MB', 'GB', 'TB', 'PB'],
            number = Math.floor(Math.log(bytes) / Math.log(1024));
        if((bytes / Math.pow(1024, Math.floor(number))).toFixed(precision) +  ' ' + units[number] != "NaN undefined"){
            return (bytes / Math.pow(1024, Math.floor(number))).toFixed(precision) +  ' ' + units[number];
        }else{
            return '-';
        }
    }
});

app.filter('charLimit', function($sce){
    return function(input, length){
        if(!length){
            length = 40;
        }
        if(!input){
            return '';
        }
        if(input.length <= length){
            return input;
        }else{
            return $sce.trustAsHtml('<span class="toolTip" data-toggle="tooltip" data-placement="top" title="'+input+'" data-original-title="'+input+'">'+ input.substring(0, length) + ' ...</span>');
        }
    }
});

app.filter('charLimitOutlook', function($sce){
    return function(input, length){
        if(!length){
            length = 100;
        }
        if(!input){
            return '';
        }
        if(input.length <= length){
            return input;
        }else{
            return $sce.trustAsHtml("<span class='toolTip' data-toggle='tooltip' data-placement='top' title='"+input+"' data-original-title='"+input+"'>"+ input.substring(0, length) + " ...</span>");
        }
    }
});

app.filter('charLimitMail', function($sce){
    return function(input, length){
        if(!length){
            length = 20;
        }
        if(!input){
            return '';
        }
        if(input.length <= length){
            return input;
        }else{
            return $sce.trustAsHtml('<span class="toolTip" data-toggle="tooltip" data-placement="top" title="'+input+'" data-original-title="'+input+'">'+ input.substring(0, length) + ' ...</span>');
        }
    }
});

app.filter('charLimitMailSearch', function($sce){
    return function(input, length){
        if(!length){
            length = 10;
        }
        if(!input){
            return '';
        }
        if(input.length <= length){
            return input;
        }else{
            return $sce.trustAsHtml('<span class="toolTip" data-toggle="tooltip" data-placement="top" title="'+input+'" data-original-title="'+input+'">'+ input.substring(0, length) + ' ...</span>');
        }
    }
});

app.filter('trustAsHtml',['$sce', function($sce) {
  return function(text) {
    return $sce.trustAsHtml(text);
  };
}]);

app.filter('startFrom', function() {
    return function(input, start) {
        start = +start; //parse to int
        return input.slice(start);
    }
});

app.directive('contextMenu', ["$parse", function ($parse) {
    var renderContextMenu = function ($scope, event, options, model) {
        if (!$) { var $ = angular.element; }
        $(event.currentTarget).addClass('context');
        var $contextMenu = $('<div>');
        $contextMenu.addClass('dropdown clearfix');
        var $ul = $('<ul>');
        $ul.addClass('dropdown-menu');
        $ul.attr({ 'role': 'menu' });
        $ul.css({
            display: 'block',
            position: 'absolute',
            left: (event.pageX) + 'px',
            top: event.pageY-10 + 'px'
        });
        angular.forEach(options, function (item, i) {
            var $li = $('<li>');
            var view_enable = $('.view_enable').html();
            var disable_download = $('.disable_download').html();
            var disable_view = $('.disable_view').html();
            if (item === null) {
                $li.addClass('divider');
            } else if(item === " "){

            } else {
                var $a = $('<a>');
                $a.css("color","black");
                $a.attr({ tabindex: '-1', href: '#' });
                var text = typeof item[0] == 'string' ? item[0] : item[0].call($scope, $scope, event);
                $a.text(text);
                $li.append($a);
                if(view_enable == 'false'){
                    if(text == "View"){
                        $li.addClass('disabled');
                        $li.css("pointer-events","none");
                    }
                }
                else if(view_enable == 'true'){$li.removeClass('disabled');}
                if(disable_download == 'true'){
                    if(text == "Download"){
                        $li.addClass('hide');
                    }
                }
                if(disable_view == 'true'){
                    if(text == "View"){
                        $li.addClass('hide');
                    }
                }
                var enabled = angular.isDefined(item[2]) ? item[2].call($scope, $scope, event, text, model) : true;
                if (enabled) {
                    $li.on('click', function ($event) {
                        $event.preventDefault();
                        $scope.$apply(function () {
                            $(event.currentTarget).removeClass('context');
                            $contextMenu.remove();
                            item[1].call($scope, $scope, event, model);
                        });
                    });
                } else {
                    $li.on('click', function ($event) {
                        $event.preventDefault();
                    });
                    $li.addClass('hide');
                }
            }
            $ul.append($li);
        });
        $contextMenu.append($ul);
        var height = Math.max(
            document.body.scrollHeight, document.documentElement.scrollHeight,
            document.body.offsetHeight, document.documentElement.offsetHeight,
            document.body.clientHeight, document.documentElement.clientHeight
        );
        $contextMenu.css({
            width: '100%',
            height: height + 'px',
            position: 'absolute',
            top: 0,
            left: 0,
            zIndex: 9999
        });
        $(document).find('body').append($contextMenu);
        $contextMenu.on("mousedown", function (e) {
            if ($(e.target).hasClass('dropdown')) {
                $(event.currentTarget).removeClass('context');
                $contextMenu.remove();
            }
        }).on('contextmenu', function (event) {
            $(event.currentTarget).removeClass('context');
            event.preventDefault();
            $contextMenu.remove();
        });
    };
    return function ($scope, element, attrs) {
        element.on('contextmenu', function (event) {
            $scope.$apply(function () {
                event.preventDefault();
                var options = $scope.$eval(attrs.contextMenu);
                var model = $scope.$eval(attrs.model);
                if (options instanceof Array) {
                    if (options.length === 0) { return; }
                    renderContextMenu($scope, event, options, model);
                } else {
                    throw '"' + attrs.contextMenu + '" not an array';
                }
            });
        });
    };
}]);

app.factory('Excel',function($window){
var uri = 'data:application/vnd.ms-excel;base64,',
template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><meta meta http-equiv="Content-Type" content="text/html; charset=UTF-8"><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
base64 = function (s) { 
    return $window.btoa(unescape(encodeURIComponent(s)));
    }, 
    format = function (s, c) { 
        return s.replace(/{(\w+)}/g, function (m, p) { return c[p]; }) }; 
        return { tableToExcel: function (tableId, worksheetName, isBase64) {
            var table = document.querySelector(tableId);
            var ctx = { worksheet: worksheetName, table: table.innerHTML };
            var href = "";
            if (isBase64) { 
                href = uri + base64(format(template, ctx));
            } else {
                href = uri + format(template, ctx);
            } 
            return href;
        } 
            
        };
});
