<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Storage extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Support Model was called', 'info');
    }

    /**
     * @param $url
     * @param $headers
     * @param $data
     * @return array
     */
    public function getGoogleRefreshToken($url, $headers, $data){
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        Model::req($url,$headers,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * @param $url
     * @return array
     */
    public function getUserInfoFromGoogle($url){
        $this->curl->get($url);
        Model::req($url,$headers,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * @param $url
     * @param $rUri
     * @param $cId
     * @param $cSec
     * @param $code
     * @return array
     */
    public function getOneDriveAuthToken($url, $cId, $rUri, $cSec, $code){
        $headers[] 	= 'Content-Type: application/x-www-form-urlencoded';
        $body 	    = "client_id=".$cId."&redirect_uri=".$rUri."&client_secret=".$cSec."&code=".$code."&grant_type=authorization_code";
        $ch 	   	= curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        if(PROXY_URL != false){
            curl_setopt($ch, CURLOPT_PROXY, PROXY_URL);
            if(PROXY_USERNAME != false){
                curl_setopt($ch, CURLOPT_PROXYUSERPWD, PROXY_USERNAME.':'.PROXY_PASSWORD);
            }
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, false );
        Model::req($url,$headers,$body);
        $response 	= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $result = array(
            'status' => ($intReturnCode == 201) ? 200 : $intReturnCode,
            'body' => $response
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveAuthCredentials($headers, $data){
        $url = $this->api->getUrl('saveAuth');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getOdbDetails($headers){
        $url = $this->api->getUrl('getOdbDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAzureAuthToken($url, $cId, $rUri, $cSec, $code){
        $headers[]  = 'Content-Type: application/x-www-form-urlencoded';
        $body = "client_id=".$cId."&redirect_uri=".$rUri."&client_secret=".$cSec."&code=".$code."&grant_type=authorization_code&resource=https://graph.microsoft.com/";
        $ch         = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        if(PROXY_URL != false){
            curl_setopt($ch, CURLOPT_PROXY, PROXY_URL);
            if(PROXY_USERNAME != false){
                curl_setopt($ch, CURLOPT_PROXYUSERPWD, PROXY_USERNAME.':'.PROXY_PASSWORD);
            }
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, false );
        Model::req($url,$headers,$body);
        $response   = curl_exec($ch);
        $intReturnCode  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $result = array(
            'status' => ($intReturnCode == 201) ? 200 : $intReturnCode,
            'body' => $response
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getAadDetails($headers){
        $url = $this->api->getParacloudUrl('getAadDetails');
        $this->log("URL : ".$url,"info");
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function saveAzureCredentials($headers, $data){
        $url = $this->api->getParacloudUrl('saveAzure');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveDetails($headers){
        $url = $this->api->getUrl('getOneDriveDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function saveOneDriveCredentials($headers, $data){
        $url = $this->api->getUrl('saveOneDriveCredentials');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getOneDriveAppAuthToken($url, $cId, $rUri, $cSec, $code){
        $headers[]  = 'Content-Type: application/x-www-form-urlencoded';
        $body = "client_id=".$cId."&redirect_uri=".$rUri."&client_secret=".$cSec."&code=".$code."&grant_type=authorization_code&resource=https://graph.microsoft.com/";
        $ch         = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        if(PROXY_URL != false){
            curl_setopt($ch, CURLOPT_PROXY, PROXY_URL);
            if(PROXY_USERNAME != false){
                curl_setopt($ch, CURLOPT_PROXYUSERPWD, PROXY_USERNAME.':'.PROXY_PASSWORD);
            }
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, false );
        Model::req($url,$headers,$body);
        $response   = curl_exec($ch);
        $intReturnCode  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $result = array(
            'status' => ($intReturnCode == 201) ? 200 : $intReturnCode,
            'body' => $response
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}