<?php
namespace Models;

use Core\Model;
use Helpers\KLogger;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class History extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('History Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDeviceBackupHistory($headers, $data, $pageNumber){
        //        $url = $this->api->getUrl('deviceBackupHistory');
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/report/backupActivityHistory?pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function userDeviceBackupHistory1($headers, $data, $url){
    //        $url = $this->api->getUrl('deviceBackupHistory');
        $url = PROTOCOL.PARACLOUD_IP.$url;;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDeviceBackupHistoryDetails($headers){
        $url = $this->api->getUrl('deviceBackupHistoryDetails');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Exports Activity History TO Excel
     *
     * @param $headers
     * @return array
     */
    public function exportActivityHistoryToExcel($headers){
        $url = $this->api->getUrl('exportActivityHistoryToExcel');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->log(json_encode($url), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Exports Activity History TO Excel
     *
     * @param $headers
     * @return array
     */
    public function exportShareActivityHistoryToExcel($headers){
        $url = $this->api->getUrl('exportShareActivityHistoryToExcel');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log(json_encode($headers), 'info');
        $this->log(json_encode($url), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getBackupActivityHistory($headers, $pageNumber, $userName){
//        $url = $this->api->getUrl('backupActivityHistory');
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/versions/2.5/clouds/".CLOUD_NAME."/activities?deviceName&userName=".$userName."&pageNumber=".$pageNumber;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getBackupActivityHistory1($headers, $url){
//        $url = $this->api->getUrl('backupActivityHistory');
        $url = PROTOCOL.PARACLOUD_IP.$url;
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->log('Headers'.json_encode($headers), 'info');
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getShareActivityHistory($headers, $pageNumber){
        $url = PROTOCOL.PARACLOUD_IP."/paracloud/cloud/".CLOUD_NAME."/files/sharedAH/all?pageNumber=".$pageNumber;
        //        $url = $this->api->getUrl('shareActivityHistory');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

    public function getShareActivityHistory1($headers, $url){
        $url = PROTOCOL.PARACLOUD_IP.$url;
        //        $url = $this->api->getUrl('shareActivityHistory');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }
    
    public function getBackupAttemps($headers){
        $url = $this->api->getParacloudUrl('getBackupAttemps');
        Model::req($url,$headers,$data);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result'.json_encode($result), 'info');
        Model::res($this->curl->response,$this->curl->response_headers,$result['status']);
        return $result;
    }

}
