<?php
namespace Helpers;

/**
 * Assets static helper
 *
 * @author volter9
 * @author QsmaPL
 * @date 27th November, 2014
 * @date May 18 2015
 */

class Assets
{
    /**
     * @var array Asset templates
     */
    protected static $templates = array
    (
        'img'  => '<img src="%s" title="" />',
        'js'  => '<script src="%s" type="text/javascript" charset="UTF-8"></script>',
        'css' => '<link href="%s" rel="stylesheet" type="text/css" charset="UTF-8">'
    );

    /**
     * Common templates for assets.
     *
     * @param string|array $files
     * @param string       $template
     */
    protected static function resource($files, $template)
    {
        $template = self::$templates[$template];

        if (is_array($files)) {
            foreach ($files as $file) {
                echo sprintf($template, $file) . "\n";
            }
        } else {
            echo sprintf($template, $files) . "\n";
        }
    }

    /**
     * Output script
     *
     * @param $files
     */
    public static function js($files)
    {
        static::resource($files, 'js');
    }

    /**
     * Output stylesheet
     *
     * @param $files
     */
    public static function css($files)
    {
        static::resource($files, 'css');
    }

    /**
     * Output stylesheet
     *
     * @param $files
     */
    public static function img($files)
    {
        $template = self::$templates['img'];

        if (is_array($files)) {
            foreach ($files as $file) {
                echo sprintf($template, $file) . "\n";
            }
        } else {
            echo sprintf($template, $files) . "\n";
        }
    }
}
