<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Support;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SupportController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('support');
        $this->_model = new Support();
        $this->verifyAndCleanItUp();
        Auth::allowOnly('readOnlyAdmin');
    }

    public function support(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'active' => 'support',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );
        
        if($this->session->get('admin') == true){
                $data['showLicenseKey'] = 'true';
        }else{
                $data['showLicenseKey'] = 'false';
        }

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('support/all', $data);
        View::renderTemplate('footer', $data);
    }

    public function getLogDetails($supportID){
        $headers = array(
            'token'         => $this->session->get('token'),
            'cloudName'     => $this->session->get('cloudName'),
            'userName'      => $this->session->get('userName')
        );
        $result = $this->_model->getLogDetails($headers, $supportID);

        if($result['status'] == 200 & !empty($result['body']->{'supportElement'})){
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'crumb1' => $this->language->get('logDetails'),
                'active' => 'support',
                'support' => $result['body']->{'supportElement'},
                'csrf_token' => $this->setCSRFToken(),
                'loggedInUser' => $this->session->all()
            );

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('support/logDetails', $data);
            View::renderTemplate('footer', $data);
        }else{
            Url::redirect('404');
        }
    }

    public function getSupportLogs(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'cloudName'     => $this->session->get('cloudName'),
                'userName'      => $this->session->get('userName'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            $result = $this->_model->getSupportLogs($headers, $_POST['pageNumber']);
            switch ($result['status']) {
                case (200):
                    $supportLogs = array();
                    if(!empty($result['body']->{'data'}->{'supportElement'})){
                        foreach($result['body']->{'data'}->{'supportElement'} as $value){
                            $log = array(
                                '_id' => (string)$value->{'id'},
                                'cloudName' => (string)$value->{'cloudName'},
                                'deviceName' => (string)$value->{'deviceName'},
                                'logFiles' => (array)$value->{'logFiles'},
                                'timeStamp' => date('d-M-Y h:i:s', (((int)$value->{'timeStamp'}) / 1000)),
                                'convertedOne' => (int)$value->{'timeStamp'},
                                'userName' => (string)$value->{'userName'}
                            );

                            $supportLogs = array_merge(array($log), $supportLogs);
                        }
                    }
                    
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }

                    $response = array(
                        'result' => 'success',
                        'supportLogs' => $supportLogs,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function getSupportLogs1(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'cloudName'     => $this->session->get('cloudName'),
                'userName'      => $this->session->get('userName'),
                'Content-type'  => 'application/json',
                'Accept'        => 'application/json',
            );
            $result = $this->_model->getSupportLogsNavigate($headers,$_POST['url']);
            switch ($result['status']) {
                case (200):
                    $supportLogs = array();
                    if(!empty($result['body']->{'data'}->{'supportElement'})){
                        foreach($result['body']->{'data'}->{'supportElement'} as $value){
                            $log = array(
                                '_id' => (string)$value->{'id'},
                                'cloudName' => (string)$value->{'cloudName'},
                                'deviceName' => (string)$value->{'deviceName'},
                                'logFiles' => (array)$value->{'logFiles'},
                                'timeStamp' => date('d-M-Y h:i:s', (((int)$value->{'timeStamp'}) / 1000)),
                                'convertedOne' => (int)$value->{'timeStamp'},
                                'userName' => (string)$value->{'userName'}
                            );

                            $supportLogs = array_merge(array($log), $supportLogs);
                        }
                    }
                    if(!empty($result['body']->{'metadata'})){
                        $metadata = $result['body']->{'metadata'};
                        $this->log("meeeeeeeeeeeee : ".json_encode($metadata),"info");
                    }else{
                        $metadata = [];
                    }
                    $response = array(
                        'result' => 'success',
                        'supportLogs' => $supportLogs,
                        'metadata' => $metadata
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }
    
    public function supportOverview(){
        $headers = array(
            'token'         => $this->session->get('token'),
        );
        $result = $this->_model->supportOverview($headers);
        $result['body']->{'responseElement'}->{'cloudValidityUntil'} = date('d-M-Y', (((int)$result['body']->{'responseElement'}->{'cloudValidityUntil'}) / 1000));
            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        //'responseElement' => $result,
                        'statistics' => $result['body']->{'responseElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }
    }

    public function downloadLog($id, $name){
        if(!empty($id) && !empty($name)){
            $path = BASE_PARACLOUD_PATH.SUPPORT_BASE_DIR.$id.DS.$name;
            if(!is_file($path) || CONNECTION_STATUS()!=0){
                Url::redirect('logDetails/'.$id);
            }
            HEADER("Cache-Control: private");
            HEADER("Pragma: public");
            HEADER("Expires: ".GMDATE("D, d M Y H:i:s", MKTIME(DATE("H")+2, DATE("i"), DATE("s"), DATE("m"), DATE("d"), DATE("Y")))." GMT");
            HEADER("Last-Modified: ".GMDATE("D, d M Y H:i:s")." GMT");
            HEADER("Content-Type: application/octet-stream");
            HEADER("Content-Length: ".(string)(FILESIZE($path)));
            HEADER("Content-Disposition: attachment; filename=".$name);
            HEADER("Content-Transfer-Encoding: binary");
            session_write_close();
            if($file = FOPEN($path, 'rb')) {
                while(!FEOF($file) && (CONNECTION_STATUS()==0)) {
                    PRINT(FREAD($file, 1024*8));
                    FLUSH();
                }
                FCLOSE($file);
            }
            return((CONNECTION_STATUS()==0) && !CONNECTION_ABORTED());
        }else{
            Url::redirect('logDetails/'.$id);
        }
    }

}
