/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query.validation;

import java.util.List;
import org.mongodb.morphia.query.validation.TypeValidator;
import org.mongodb.morphia.query.validation.ValidationFailure;

public class LongTypeValidator
extends TypeValidator {
    private static final LongTypeValidator INSTANCE = new LongTypeValidator();

    public static LongTypeValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean appliesTo(Class<?> type) {
        return type == Long.TYPE || type == Long.class;
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (value.getClass() != Long.TYPE && value.getClass() != Long.class && value.getClass() != Integer.TYPE && value.getClass() != Integer.class) {
            validationFailures.add(new ValidationFailure(String.format("When type is a long the value should be a long or integer.  Type was %s and value '%s' was a %s", type, value, value.getClass())));
        }
    }
}

