/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.util.Set;
import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.annotations.Version;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;

public class VersionMisuse
extends FieldConstraint {
    private ObjectFactory creator;

    public VersionMisuse(ObjectFactory creator) {
        this.creator = creator;
    }

    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(Version.class)) {
            Class type = mf.getType();
            if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
                Object testInstance = this.creator.createInstance(mc.getClazz());
                if (Long.class.equals((Object)type)) {
                    if (mf.getFieldValue(testInstance) != null) {
                        ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), String.format("When using @%s on a Long field, it must be initialized to null.", Version.class.getSimpleName())));
                    }
                } else if (Long.TYPE.equals(type) && (Long)mf.getFieldValue(testInstance) != 0L) {
                    ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), String.format("When using @%s on a long field, it must be initialized to 0.", Version.class.getSimpleName())));
                }
            } else {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), String.format("@%s can only be used on a Long/long field.", Version.class.getSimpleName())));
            }
        }
    }
}

