/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.util.Set;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;

public class IdDoesNotMix
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(Id.class) && (mf.hasAnnotation(Reference.class) || mf.hasAnnotation(Embedded.class) || mf.hasAnnotation(Property.class))) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), mf.getFullName() + " is annotated as @" + Id.class.getSimpleName() + " and cannot be mixed with other annotations (like @Reference)"));
        }
    }
}

