/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;

public class ContradictingFieldAnnotation
extends FieldConstraint {
    private final Class<? extends Annotation> a1;
    private final Class<? extends Annotation> a2;

    public ContradictingFieldAnnotation(Class<? extends Annotation> a1, Class<? extends Annotation> a2) {
        this.a1 = a1;
        this.a2 = a2;
    }

    @Override
    protected final void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(this.a1) && mf.hasAnnotation(this.a2)) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), String.format("A field can be either annotated with @%s OR @%s, but not both.", this.a1.getSimpleName(), this.a2.getSimpleName())));
        }
    }
}

