/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bson.BasicBSONEncoder;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.EntityInterceptor;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.annotations.Converters;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.PostLoad;
import org.mongodb.morphia.annotations.PreLoad;
import org.mongodb.morphia.annotations.PrePersist;
import org.mongodb.morphia.annotations.PreSave;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.converters.CustomConverters;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.EmbeddedMapper;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.MapperOptions;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.Serializer;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.mapping.lazy.LazyFeatureDependencies;
import org.mongodb.morphia.mapping.lazy.LazyProxyFactory;
import org.mongodb.morphia.mapping.lazy.proxy.ProxiedEntityReference;
import org.mongodb.morphia.mapping.lazy.proxy.ProxyHelper;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryImpl;
import org.mongodb.morphia.query.ValidationException;
import org.mongodb.morphia.utils.ReflectionUtils;

public class Mapper {
    public static final String ID_KEY = "_id";
    public static final String IGNORED_FIELDNAME = ".";
    public static final String CLASS_NAME_FIELDNAME = "className";
    private static final Logger LOG = MorphiaLoggerFactory.get(Mapper.class);
    private final Map<String, MappedClass> mappedClasses = new ConcurrentHashMap<String, MappedClass>();
    private final ConcurrentHashMap<String, Set<MappedClass>> mappedClassesByCollection = new ConcurrentHashMap();
    private final List<EntityInterceptor> interceptors = new LinkedList<EntityInterceptor>();
    private final Map<Class, Object> instanceCache = new ConcurrentHashMap<Class, Object>();
    private final LazyProxyFactory proxyFactory = LazyFeatureDependencies.createDefaultProxyFactory();
    private final org.mongodb.morphia.converters.Converters converters;
    private MapperOptions opts = new MapperOptions();

    public Mapper(MapperOptions opts) {
        this();
        this.opts = opts;
    }

    public Mapper() {
        this.converters = new CustomConverters(this);
    }

    public Mapper(MapperOptions options, Mapper mapper) {
        this(options);
        for (MappedClass mappedClass : mapper.getMappedClasses()) {
            this.addMappedClass(mappedClass, false);
        }
    }

    public void addInterceptor(EntityInterceptor ei) {
        this.interceptors.add(ei);
    }

    public MappedClass addMappedClass(Class c) {
        MappedClass mappedClass = this.mappedClasses.get(c.getName());
        if (mappedClass == null) {
            mappedClass = new MappedClass(c, this);
            return this.addMappedClass(mappedClass, true);
        }
        return mappedClass;
    }

    public EntityCache createEntityCache() {
        return this.getOptions().getCacheFactory().createCache();
    }

    public <T> T fromDBObject(Datastore datastore, Class<T> entityClass, DBObject dbObject, EntityCache cache) {
        if (dbObject == null) {
            Throwable t = new Throwable();
            LOG.error("A null reference was passed in for the dbObject", t);
            return null;
        }
        T entity = this.opts.getObjectFactory().createInstance(entityClass, dbObject);
        entity = this.fromDb(datastore, dbObject, entity, cache);
        return entity;
    }

    public List<MappedClass> getSubTypes(MappedClass mc) {
        ArrayList<MappedClass> subtypes = new ArrayList<MappedClass>();
        for (MappedClass mappedClass : this.getMappedClasses()) {
            if (!mappedClass.isSubType(mc)) continue;
            subtypes.add(mappedClass);
        }
        return subtypes;
    }

    <T> T fromDBObject(Datastore datastore, DBObject dbObject) {
        if (dbObject.containsField(CLASS_NAME_FIELDNAME)) {
            Object entity = this.opts.getObjectFactory().createInstance(null, dbObject);
            entity = this.fromDb(datastore, dbObject, entity, this.createEntityCache());
            return entity;
        }
        throw new MappingException(String.format("The DBOBbject does not contain a %s key.  Determining entity type is impossible.", CLASS_NAME_FIELDNAME));
    }

    public <T> T fromDb(Datastore datastore, DBObject dbObject, T entity, EntityCache cache) {
        Iterator<String> cachedInstance;
        if (entity instanceof MappedField) {
            this.readMappedField(datastore, (MappedField)entity, entity, cache, dbObject);
            return entity;
        }
        if (dbObject.containsField(ID_KEY) && this.getMappedClass(entity).getIdField() != null && this.getMappedClass(entity).getEntityAnnotation() != null) {
            Key key = new Key(entity.getClass(), this.getCollectionName(entity.getClass()), dbObject.get(ID_KEY));
            cachedInstance = cache.getEntity(key);
            if (cachedInstance != null) {
                return (T)cachedInstance;
            }
            cache.putEntity(key, entity);
        }
        if (entity instanceof Map) {
            Map map = (Map)entity;
            cachedInstance = dbObject.keySet().iterator();
            while (cachedInstance.hasNext()) {
                String key;
                Object o = dbObject.get(key = cachedInstance.next());
                map.put(key, o instanceof DBObject ? this.fromDBObject(datastore, (DBObject)o) : o);
            }
        } else if (entity instanceof Collection) {
            Collection collection = (Collection)entity;
            for (String o : (List)((Object)dbObject)) {
                collection.add(o instanceof DBObject ? this.fromDBObject(datastore, (DBObject)((Object)o)) : o);
            }
        } else {
            MappedClass mc = this.getMappedClass(entity);
            DBObject updated = mc.callLifecycleMethods(PreLoad.class, entity, dbObject, this);
            try {
                for (MappedField mf : mc.getPersistenceFields()) {
                    this.readMappedField(datastore, mf, entity, cache, updated);
                }
            }
            catch (MappingException e) {
                Object id = dbObject.get(ID_KEY);
                String entityName = entity.getClass().getName();
                throw new MappingException(String.format("Could not map %s with ID: %s in database '%s'", entityName, id, datastore.getDB().getName()), e);
            }
            if (updated.containsField(ID_KEY) && this.getMappedClass(entity).getIdField() != null) {
                Key key = new Key(entity.getClass(), this.getCollectionName(entity.getClass()), updated.get(ID_KEY));
                cache.putEntity(key, entity);
            }
            mc.callLifecycleMethods(PostLoad.class, entity, updated, this);
        }
        return entity;
    }

    public Class<?> getClassFromCollection(String collection) {
        Set<MappedClass> mcs = this.mappedClassesByCollection.get(collection);
        if (mcs == null || mcs.isEmpty()) {
            throw new MappingException(String.format("The collection '%s' is not mapped to a java class.", collection));
        }
        if (mcs.size() > 1 && LOG.isInfoEnabled()) {
            LOG.info(String.format("Found more than one class mapped to collection '%s'%s", collection, mcs));
        }
        return mcs.iterator().next().getClazz();
    }

    public String getCollectionName(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        MappedClass mc = this.getMappedClass(object);
        return mc.getCollectionName();
    }

    public org.mongodb.morphia.converters.Converters getConverters() {
        return this.converters;
    }

    public Object getId(Object entity) {
        Object unwrapped = entity;
        if (unwrapped == null) {
            return null;
        }
        unwrapped = ProxyHelper.unwrap(unwrapped);
        try {
            return this.getMappedClass(unwrapped.getClass()).getIdField().get(unwrapped);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<Class, Object> getInstanceCache() {
        return this.instanceCache;
    }

    public Collection<EntityInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public <T> Key<T> getKey(T entity) {
        T unwrapped = entity;
        if (unwrapped instanceof ProxiedEntityReference) {
            ProxiedEntityReference proxy = (ProxiedEntityReference)unwrapped;
            return proxy.__getKey();
        }
        if ((unwrapped = ProxyHelper.unwrap(unwrapped)) instanceof Key) {
            return (Key)unwrapped;
        }
        Object id = this.getId(unwrapped);
        Class<?> aClass = unwrapped.getClass();
        return id == null ? null : new Key(aClass, this.getCollectionName(aClass), id);
    }

    public <T> Key<T> getKey(T entity, String collection) {
        T unwrapped = entity;
        if (unwrapped instanceof ProxiedEntityReference) {
            ProxiedEntityReference proxy = (ProxiedEntityReference)unwrapped;
            return proxy.__getKey();
        }
        if ((unwrapped = ProxyHelper.unwrap(unwrapped)) instanceof Key) {
            return (Key)unwrapped;
        }
        Object id = this.getId(unwrapped);
        Class<?> aClass = unwrapped.getClass();
        return id == null ? null : new Key(aClass, collection, id);
    }

    public <T> List<Key<T>> getKeysByManualRefs(Class<T> clazz, List<Object> refs) {
        String collection = this.getCollectionName(clazz);
        ArrayList<Key<T>> keys = new ArrayList<Key<T>>(refs.size());
        for (Object ref : refs) {
            keys.add(this.manualRefToKey(collection, ref));
        }
        return keys;
    }

    public <T> List<Key<T>> getKeysByRefs(List<DBRef> refs) {
        ArrayList<Key<T>> keys = new ArrayList<Key<T>>(refs.size());
        for (DBRef ref : refs) {
            Key<T> testKey = this.refToKey(ref);
            keys.add(testKey);
        }
        return keys;
    }

    public Map<String, MappedClass> getMCMap() {
        return Collections.unmodifiableMap(this.mappedClasses);
    }

    public MappedClass getMappedClass(Object obj) {
        MappedClass mc;
        Class type;
        if (obj == null) {
            return null;
        }
        Class clazz = type = obj instanceof Class ? (Class)obj : obj.getClass();
        if (ProxyHelper.isProxy(obj)) {
            type = ProxyHelper.getReferentClass(obj);
        }
        if ((mc = this.mappedClasses.get(type.getName())) == null) {
            mc = new MappedClass(type, this);
            this.addMappedClass(mc, false);
        }
        return mc;
    }

    public Collection<MappedClass> getMappedClasses() {
        return new ArrayList<MappedClass>(this.mappedClasses.values());
    }

    public MapperOptions getOptions() {
        return this.opts;
    }

    public void setOptions(MapperOptions options) {
        this.opts = options;
    }

    public boolean isMapped(Class c) {
        return this.mappedClasses.containsKey(c.getName());
    }

    public DBRef keyToDBRef(Key key) {
        Object id;
        if (key == null) {
            return null;
        }
        if (key.getType() == null && key.getCollection() == null) {
            throw new IllegalStateException("How can it be missing both?");
        }
        if (key.getCollection() == null) {
            key.setCollection(this.getCollectionName(key.getType()));
        }
        if (this.isMapped((id = key.getId()).getClass())) {
            id = this.toMongoObject(id, true);
        }
        return new DBRef(key.getCollection(), id);
    }

    public <T> Key<T> manualRefToKey(Class<T> type, Object id) {
        return id == null ? null : new Key<T>(type, this.getCollectionName(type), id);
    }

    public <T> Key<T> refToKey(DBRef ref) {
        return ref == null ? null : new Key(this.getClassFromCollection(ref.getCollectionName()), ref.getCollectionName(), ref.getId());
    }

    public DBObject toDBObject(Object entity) {
        return this.toDBObject(entity, null);
    }

    public DBObject toDBObject(Object entity, Map<Object, DBObject> involvedObjects) {
        return this.toDBObject(entity, involvedObjects, true);
    }

    public Object toMongoObject(MappedField mf, MappedClass mc, Object value) {
        if (value == null) {
            return null;
        }
        Object mappedValue = value;
        if (value instanceof Query) {
            mappedValue = ((QueryImpl)value).getQueryObject();
        } else if (this.isAssignable(mf, value) || this.isEntity(mc)) {
            try {
                if (value instanceof Iterable) {
                    MappedClass mapped = this.getMappedClass(mf.getSubClass());
                    mappedValue = mapped != null && (Key.class.isAssignableFrom(mapped.getClazz()) || mapped.getEntityAnnotation() != null) ? this.getDBRefs(mf, (Iterable)value) : (mf.hasAnnotation(Reference.class) ? this.getDBRefs(mf, (Iterable)value) : this.toMongoObject(value, false));
                } else {
                    if (mf != null) {
                        Reference refAnn = mf.getAnnotation(Reference.class);
                        Class idType = null;
                        if (!mf.getType().equals(Key.class) && this.isMapped(mf.getType())) {
                            idType = this.getMappedClass(mf.getType()).getMappedIdField().getType();
                        }
                        boolean valueIsIdType = mappedValue.getClass().equals(idType);
                        if (refAnn != null) {
                            if (!valueIsIdType) {
                                Key<Object> key;
                                Key<Object> key2 = key = value instanceof Key ? (Key<Object>)value : this.getKey(value);
                                if (key != null) {
                                    mappedValue = refAnn.idOnly() ? this.keyToId(key) : this.keyToDBRef(key);
                                }
                            }
                        } else if (mf.getType().equals(Key.class) && (mappedValue = this.keyToDBRef(valueIsIdType ? this.createKey(mf.getSubClass(), value) : (value instanceof Key ? (Key<Object>)value : this.getKey(value)))) == value) {
                            throw new ValidationException("cannot map to Key<T> field: " + value);
                        }
                    }
                    if (mappedValue == value) {
                        mappedValue = this.toMongoObject(value, false);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error converting value(" + value + ") to reference.", e);
                mappedValue = this.toMongoObject(value, false);
            }
        } else if (mf != null && mf.hasAnnotation(Serialized.class)) {
            try {
                mappedValue = Serializer.serialize(value, !mf.getAnnotation(Serialized.class).disableCompression());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (value instanceof DBObject) {
            mappedValue = value;
        } else if ((mappedValue = this.toMongoObject(value, EmbeddedMapper.shouldSaveClassName(value, mappedValue, mf))) instanceof BasicDBList) {
            BasicDBList list = (BasicDBList)mappedValue;
            if (list.size() != 0 && !EmbeddedMapper.shouldSaveClassName(this.extractFirstElement(value), list.get(0), mf)) {
                for (Object o : list) {
                    if (!(o instanceof DBObject)) continue;
                    ((DBObject)o).removeField(CLASS_NAME_FIELDNAME);
                }
            }
        } else if (mappedValue instanceof DBObject && !EmbeddedMapper.shouldSaveClassName(value, mappedValue, mf)) {
            ((DBObject)mappedValue).removeField(CLASS_NAME_FIELDNAME);
        }
        return mappedValue;
    }

    public String updateCollection(Key key) {
        if (key.getCollection() == null && key.getType() == null) {
            throw new IllegalStateException("Key is invalid! " + this.toString());
        }
        if (key.getCollection() == null) {
            key.setCollection(this.getMappedClass(key.getType()).getCollectionName());
        }
        return key.getCollection();
    }

    public void updateKeyAndVersionInfo(Datastore datastore, DBObject dbObj, EntityCache cache, Object entity) {
        MappedClass mc = this.getMappedClass(entity);
        if (mc.getIdField() != null && dbObj != null && dbObj.get(ID_KEY) != null) {
            try {
                Object dbIdValue;
                MappedField mf = mc.getMappedIdField();
                Object oldIdValue = mc.getIdField().get(entity);
                this.readMappedField(datastore, mf, entity, cache, dbObj);
                if (oldIdValue != null && !(dbIdValue = mf.getFieldValue(entity)).equals(oldIdValue)) {
                    mf.setFieldValue(entity, oldIdValue);
                    throw new RuntimeException(String.format("@Id mismatch: %s != %s for %s", oldIdValue, dbIdValue, entity.getClass().getName()));
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Error setting @Id field after save/insert.", e);
            }
        }
        if (mc.getMappedVersionField() != null && dbObj != null) {
            this.readMappedField(datastore, mc.getMappedVersionField(), entity, cache, dbObj);
        }
    }

    protected LazyProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    private void addConverters(MappedClass mc) {
        List convertersList = mc.getAnnotations(Converters.class);
        if (convertersList != null) {
            for (Annotation a : convertersList) {
                Converters c = (Converters)a;
                if (c == null) continue;
                for (Class<? extends TypeConverter> clazz : c.value()) {
                    if (this.getConverters().isRegistered(clazz)) continue;
                    this.getConverters().addConverter(clazz);
                }
            }
        }
    }

    private MappedClass addMappedClass(MappedClass mc, boolean validate) {
        this.addConverters(mc);
        if (validate && !mc.isInterface()) {
            mc.validate(this);
        }
        this.mappedClasses.put(mc.getClazz().getName(), mc);
        Set<MappedClass> mcs = this.mappedClassesByCollection.get(mc.getCollectionName());
        if (mcs == null) {
            mcs = new CopyOnWriteArraySet<MappedClass>();
            Set<MappedClass> temp = this.mappedClassesByCollection.putIfAbsent(mc.getCollectionName(), mcs);
            if (temp != null) {
                mcs = temp;
            }
        }
        mcs.add(mc);
        return mc;
    }

    private Object extractFirstElement(Object value) {
        return value.getClass().isArray() ? Array.get(value, 0) : ((Iterable)value).iterator().next();
    }

    private Object getDBRefs(MappedField field, Iterable value) {
        ArrayList<Object> refs = new ArrayList<Object>();
        Reference annotation = field.getAnnotation(Reference.class);
        boolean idOnly = annotation != null && annotation.idOnly();
        for (Object o : value) {
            Key key = o instanceof Key ? (Key)o : this.getKey(o);
            refs.add(idOnly ? key.getId() : this.keyToDBRef(key));
        }
        return refs;
    }

    private Class<? extends Annotation> getFieldAnnotation(MappedField mf) {
        Class annType = null;
        for (Class testType : new Class[]{Property.class, Embedded.class, Serialized.class, Reference.class}) {
            if (!mf.hasAnnotation(testType)) continue;
            annType = testType;
            break;
        }
        return annType;
    }

    private boolean isAssignable(MappedField mf, Object value) {
        return mf != null && (mf.hasAnnotation(Reference.class) || Key.class.isAssignableFrom(mf.getType()) || DBRef.class.isAssignableFrom(mf.getType()) || this.isMultiValued(mf, value));
    }

    private boolean isEntity(MappedClass mc) {
        return mc != null && mc.getEntityAnnotation() != null;
    }

    private boolean isMultiValued(MappedField mf, Object value) {
        Class subClass = mf.getSubClass();
        return value instanceof Iterable && mf.isMultipleValues() && (Key.class.isAssignableFrom(subClass) || DBRef.class.isAssignableFrom(subClass));
    }

    private void readMappedField(Datastore datastore, MappedField mf, Object entity, EntityCache cache, DBObject dbObject) {
        if (mf.hasAnnotation(Property.class) || mf.hasAnnotation(Serialized.class) || mf.isTypeMongoCompatible() || this.getConverters().hasSimpleValueConverter(mf)) {
            this.opts.getValueMapper().fromDBObject(datastore, dbObject, mf, entity, cache, this);
        } else if (mf.hasAnnotation(Embedded.class)) {
            this.opts.getEmbeddedMapper().fromDBObject(datastore, dbObject, mf, entity, cache, this);
        } else if (mf.hasAnnotation(Reference.class)) {
            this.opts.getReferenceMapper().fromDBObject(datastore, dbObject, mf, entity, cache, this);
        } else {
            this.opts.getDefaultMapper().fromDBObject(datastore, dbObject, mf, entity, cache, this);
        }
    }

    private void writeMappedField(DBObject dbObject, MappedField mf, Object entity, Map<Object, DBObject> involvedObjects) {
        if (mf.hasAnnotation(NotSaved.class)) {
            return;
        }
        Class<? extends Annotation> annType = this.getFieldAnnotation(mf);
        if (Property.class.equals(annType) || Serialized.class.equals(annType) || mf.isTypeMongoCompatible() || this.getConverters().hasSimpleValueConverter(mf) || this.getConverters().hasSimpleValueConverter(mf.getFieldValue(entity))) {
            this.opts.getValueMapper().toDBObject(entity, mf, dbObject, involvedObjects, this);
        } else if (Reference.class.equals(annType)) {
            this.opts.getReferenceMapper().toDBObject(entity, mf, dbObject, involvedObjects, this);
        } else if (Embedded.class.equals(annType)) {
            this.opts.getEmbeddedMapper().toDBObject(entity, mf, dbObject, involvedObjects, this);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No annotation was found, using default mapper " + this.opts.getDefaultMapper() + " for " + mf);
            }
            this.opts.getDefaultMapper().toDBObject(entity, mf, dbObject, involvedObjects, this);
        }
    }

    <T> Key<T> manualRefToKey(String collection, Object id) {
        return id == null ? null : new Key(this.getClassFromCollection(collection), collection, id);
    }

    Object keyToId(Key key) {
        return key == null ? null : key.getId();
    }

    Object toMongoObject(Object javaObj, boolean includeClassName) {
        Object newObj;
        if (javaObj == null) {
            return null;
        }
        Class<?> origClass = javaObj.getClass();
        if (origClass.isAnonymousClass() && origClass.getSuperclass().isEnum()) {
            origClass = origClass.getSuperclass();
        }
        if ((newObj = this.getConverters().encode(origClass, javaObj)) == null) {
            LOG.warning("converted " + javaObj + " to null");
            return null;
        }
        Class<?> type = newObj.getClass();
        boolean bSameType = origClass.equals(type);
        if (!(bSameType || Map.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type))) {
            return newObj;
        }
        boolean isSingleValue = true;
        boolean isMap = false;
        Class subType = null;
        if (type.isArray() || Map.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type)) {
            isSingleValue = false;
            isMap = ReflectionUtils.implementsInterface(type, Map.class);
            Class clazz = type.isArray() ? type.getComponentType() : (subType = ReflectionUtils.getParameterizedClass(type, isMap ? 1 : 0));
        }
        if (isSingleValue && !ReflectionUtils.isPropertyType(type)) {
            DBObject dbObj = this.toDBObject(newObj);
            if (!includeClassName) {
                dbObj.removeField(CLASS_NAME_FIELDNAME);
            }
            return dbObj;
        }
        if (newObj instanceof DBObject) {
            return newObj;
        }
        if (isMap) {
            if (ReflectionUtils.isPropertyType(subType)) {
                return this.toDBObject(newObj);
            }
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)newObj).entrySet()) {
                m.put(entry.getKey(), this.toMongoObject(entry.getValue(), includeClassName));
            }
            return m;
        }
        if (!isSingleValue && !ReflectionUtils.isPropertyType(subType)) {
            BasicDBList values = new BasicDBList();
            if (type.isArray()) {
                for (Object obj : (Object[])newObj) {
                    values.add(this.toMongoObject(obj, includeClassName));
                }
            } else {
                for (Object t : (Iterable)newObj) {
                    values.add(this.toMongoObject(t, includeClassName));
                }
            }
            return values;
        }
        return newObj;
    }

    DBObject toDBObject(Object entity, Map<Object, DBObject> involvedObjects, boolean lifecycle) {
        DBObject dbObject = new BasicDBObject();
        MappedClass mc = this.getMappedClass(entity);
        if (mc.getEntityAnnotation() == null || !mc.getEntityAnnotation().noClassnameStored()) {
            dbObject.put(CLASS_NAME_FIELDNAME, entity.getClass().getName());
        }
        if (lifecycle) {
            dbObject = mc.callLifecycleMethods(PrePersist.class, entity, dbObject, this);
        }
        for (MappedField mf : mc.getPersistenceFields()) {
            try {
                this.writeMappedField(dbObject, mf, entity, involvedObjects);
            }
            catch (Exception e) {
                throw new MappingException("Error mapping field:" + mf.getFullName(), e);
            }
        }
        if (involvedObjects != null) {
            involvedObjects.put(entity, dbObject);
        }
        if (lifecycle) {
            mc.callLifecycleMethods(PreSave.class, entity, dbObject, this);
        }
        return dbObject;
    }

    <T> Key<T> createKey(Class<T> clazz, Serializable id) {
        return new Key<T>(clazz, this.getCollectionName(clazz), id);
    }

    <T> Key<T> createKey(Class<T> clazz, Object id) {
        if (id instanceof Serializable) {
            return this.createKey(clazz, (Serializable)id);
        }
        BasicBSONEncoder enc = new BasicBSONEncoder();
        return new Key<T>(clazz, this.getCollectionName(clazz), enc.encode(this.toDBObject(id)));
    }
}

