/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.annotations.AlsoLoad;
import org.mongodb.morphia.annotations.ConstructorArgs;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.annotations.Text;
import org.mongodb.morphia.annotations.Transient;
import org.mongodb.morphia.annotations.Version;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.EphemeralMappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.utils.ReflectionUtils;

public class MappedField {
    private static final Logger LOG = MorphiaLoggerFactory.get(MappedField.class);
    private static final List<Class<? extends Annotation>> INTERESTING = new ArrayList<Class<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, Annotation> foundAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private final List<MappedField> typeParameters = new ArrayList<MappedField>();
    private Class persistedClass;
    private Field field;
    private Class realType;
    private Constructor constructor;
    private Type subType;
    private Type mapKeyType;
    private boolean isSingleValue = true;
    private boolean isMongoType;
    private boolean isMap;
    private boolean isSet;
    private boolean isArray;
    private boolean isCollection;
    private Type genericType;

    MappedField(Field f, Class<?> clazz, Mapper mapper) {
        f.setAccessible(true);
        this.field = f;
        this.persistedClass = clazz;
        this.realType = this.field.getType();
        this.genericType = this.field.getGenericType();
        this.discover(mapper);
    }

    MappedField(Field field, Type type, Mapper mapper) {
        this.field = field;
        this.genericType = type;
        this.discoverType(mapper);
    }

    public static void addInterestingAnnotation(Class<? extends Annotation> annotation) {
        INTERESTING.add(annotation);
    }

    public void addAnnotation(Class<? extends Annotation> clazz) {
        if (this.field.isAnnotationPresent(clazz)) {
            this.foundAnnotations.put(clazz, this.field.getAnnotation(clazz));
        }
    }

    public void addAnnotation(Class<? extends Annotation> clazz, Annotation ann) {
        this.foundAnnotations.put(clazz, ann);
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)this.foundAnnotations.get(clazz);
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return this.foundAnnotations;
    }

    public Constructor getCTor() {
        return this.constructor;
    }

    public Class getConcreteType() {
        Class<?> concrete;
        Class<?> concrete2;
        Embedded e = this.getAnnotation(Embedded.class);
        if (e != null && (concrete2 = e.concreteClass()) != Object.class) {
            return concrete2;
        }
        Property p = this.getAnnotation(Property.class);
        if (p != null && (concrete = p.concreteClass()) != Object.class) {
            return concrete;
        }
        return this.getType();
    }

    public Object getDbObjectValue(DBObject dbObj) {
        return dbObj.get(this.getFirstFieldName(dbObj));
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Field getField() {
        return this.field;
    }

    public Object getFieldValue(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFirstFieldName(DBObject dbObj) {
        String fieldName = this.getNameToStore();
        boolean foundField = false;
        for (String n : this.getLoadNames()) {
            if (!dbObj.containsField(n)) continue;
            if (!foundField) {
                foundField = true;
                fieldName = n;
                continue;
            }
            throw new MappingException(String.format("Found more than one field from @AlsoLoad %s", this.getLoadNames()));
        }
        return fieldName;
    }

    public String getFullName() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    public String getJavaFieldName() {
        return this.field.getName();
    }

    public List<String> getLoadNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.getMappedFieldName());
        AlsoLoad al = (AlsoLoad)this.foundAnnotations.get(AlsoLoad.class);
        if (al != null && al.value() != null && al.value().length > 0) {
            names.addAll(Arrays.asList(al.value()));
        }
        return names;
    }

    public Class getMapKeyClass() {
        return this.toClass(this.mapKeyType);
    }

    public String getNameToStore() {
        return this.getMappedFieldName();
    }

    public Class getSubClass() {
        return this.toClass(this.subType);
    }

    public Type getSubType() {
        return this.subType;
    }

    public boolean isTransient() {
        return this.hasAnnotation(Transient.class) || Modifier.isTransient(this.field.getModifiers());
    }

    void setSubType(Type subType) {
        this.subType = subType;
    }

    public Class getType() {
        return this.realType;
    }

    public List<MappedField> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean hasAnnotation(Class ann) {
        return this.foundAnnotations.containsKey(ann);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isMultipleValues() {
        return !this.isSingleValue();
    }

    public boolean isReference() {
        return this.hasAnnotation(Reference.class) || Key.class == this.getConcreteType() || DBRef.class == this.getConcreteType();
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isSingleValue() {
        if (!(this.isSingleValue || this.isMap || this.isSet || this.isArray || this.isCollection)) {
            throw new RuntimeException("Not single, but none of the types that are not-single.");
        }
        return this.isSingleValue;
    }

    public boolean isTypeMongoCompatible() {
        return this.isMongoType;
    }

    public Annotation putAnnotation(Annotation ann) {
        return this.foundAnnotations.put(ann.getClass(), ann);
    }

    public void setFieldValue(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMappedFieldName()).append(" (");
        sb.append(" type:").append(this.realType.getSimpleName()).append(",");
        if (this.isSingleValue()) {
            sb.append(" single:true,");
        } else {
            sb.append(" multiple:true,");
            sb.append(" subtype:").append(this.getSubClass()).append(",");
        }
        if (this.isMap()) {
            sb.append(" map:true,");
            if (this.getMapKeyClass() != null) {
                sb.append(" map-key:").append(this.getMapKeyClass().getSimpleName());
            } else {
                sb.append(" map-key: class unknown! ");
            }
        }
        if (this.isSet()) {
            sb.append(" set:true,");
        }
        if (this.isCollection) {
            sb.append(" collection:true,");
        }
        if (this.isArray) {
            sb.append(" array:true,");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("); ").append(this.foundAnnotations.toString());
        return sb.toString();
    }

    protected void discover(Mapper mapper) {
        for (Class<? extends Annotation> clazz : INTERESTING) {
            this.addAnnotation(clazz);
        }
        this.discoverType(mapper);
        this.constructor = this.discoverConstructor();
        this.discoverMultivalued();
        this.isMongoType = ReflectionUtils.isPropertyType(this.realType);
        if (!this.isMongoType && this.subType != null) {
            this.isMongoType = ReflectionUtils.isPropertyType(this.subType);
        }
        if (!(this.isMongoType || this.isSingleValue || this.subType != null && this.subType != Object.class)) {
            if (LOG.isWarningEnabled() && !mapper.getConverters().hasDbObjectConverter(this)) {
                LOG.warning(String.format("The multi-valued field '%s' is a possible heterogeneous collection. It cannot be verified. Please declare a valid type to get rid of this warning. %s", this.getFullName(), this.subType));
            }
            this.isMongoType = true;
        }
    }

    protected void discoverType(Mapper mapper) {
        if (this.genericType instanceof TypeVariable) {
            this.realType = this.extractTypeVariable((TypeVariable)this.genericType);
        } else if (this.genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.genericType;
            Type[] types = pt.getActualTypeArguments();
            this.realType = this.toClass(pt);
            for (Type type : types) {
                if (type instanceof ParameterizedType) {
                    this.typeParameters.add(new EphemeralMappedField((ParameterizedType)type, this, mapper));
                    continue;
                }
                if (type instanceof WildcardType) {
                    type = ((WildcardType)type).getUpperBounds()[0];
                }
                this.typeParameters.add(new EphemeralMappedField(type, this, mapper));
            }
        } else if (this.genericType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)this.genericType;
            Type[] types = wildcardType.getUpperBounds();
            this.realType = this.toClass(types[0]);
        } else if (this.genericType instanceof Class) {
            this.realType = (Class)this.genericType;
        } else if (this.genericType instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)this.genericType).getGenericComponentType();
            if (genericComponentType instanceof ParameterizedType) {
                Type[] types;
                ParameterizedType pt = (ParameterizedType)genericComponentType;
                this.realType = this.toClass(this.genericType);
                for (Type type : types = pt.getActualTypeArguments()) {
                    if (type instanceof ParameterizedType) {
                        this.typeParameters.add(new EphemeralMappedField((ParameterizedType)type, this, mapper));
                        continue;
                    }
                    if (type instanceof WildcardType) {
                        type = ((WildcardType)type).getUpperBounds()[0];
                    }
                    this.typeParameters.add(new EphemeralMappedField(type, this, mapper));
                }
            } else {
                this.realType = genericComponentType instanceof TypeVariable ? this.toClass(this.genericType) : (Class)genericComponentType;
            }
        }
        if ((Object.class.equals((Object)this.realType) || Object[].class.equals((Object)this.realType)) && LOG.isWarningEnabled()) {
            LOG.warning(String.format("Parameterized types are treated as untyped Objects. See field '%s' on %s", this.field.getName(), this.field.getDeclaringClass()));
        }
        if (this.realType == null) {
            throw new MappingException(String.format("A type could not be found for the field %s.%s", this.getType(), this.getField()));
        }
    }

    private Class extractTypeVariable(TypeVariable<?> type) {
        Class<?> typeArgument = ReflectionUtils.getTypeArgument(this.persistedClass, type);
        return typeArgument != null ? typeArgument : Object.class;
    }

    protected String getMappedFieldName() {
        Version me;
        if (this.hasAnnotation(Id.class)) {
            return "_id";
        }
        if (this.hasAnnotation(Property.class)) {
            Property mv = (Property)this.foundAnnotations.get(Property.class);
            if (!mv.value().equals(".")) {
                return mv.value();
            }
        } else if (this.hasAnnotation(Reference.class)) {
            Reference mr = (Reference)this.foundAnnotations.get(Reference.class);
            if (!mr.value().equals(".")) {
                return mr.value();
            }
        } else if (this.hasAnnotation(Embedded.class)) {
            Embedded me2 = (Embedded)this.foundAnnotations.get(Embedded.class);
            if (!me2.value().equals(".")) {
                return me2.value();
            }
        } else if (this.hasAnnotation(Serialized.class)) {
            Serialized me3 = (Serialized)this.foundAnnotations.get(Serialized.class);
            if (!me3.value().equals(".")) {
                return me3.value();
            }
        } else if (this.hasAnnotation(Version.class) && !(me = (Version)this.foundAnnotations.get(Version.class)).value().equals(".")) {
            return me.value();
        }
        return this.field.getName();
    }

    protected Class toClass(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            Class<Object> aClass;
            Type type = ((GenericArrayType)t).getGenericComponentType();
            if (type instanceof ParameterizedType) {
                aClass = (Class<?>)((ParameterizedType)type).getRawType();
            } else if (type instanceof TypeVariable) {
                aClass = ReflectionUtils.getTypeArgument(this.persistedClass, (TypeVariable)type);
                if (aClass == null) {
                    aClass = Object.class;
                }
            } else {
                aClass = (Class)type;
            }
            return Array.newInstance(aClass, 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof WildcardType) {
            return (Class)((WildcardType)t).getUpperBounds()[0];
        }
        throw new RuntimeException("Generic TypeVariable not supported!");
    }

    private Constructor discoverConstructor() {
        block14: {
            Class type = null;
            for (Annotation an : this.foundAnnotations.values()) {
                try {
                    Method m = an.getClass().getMethod("concreteClass", new Class[0]);
                    m.setAccessible(true);
                    Object o = m.invoke((Object)an, new Object[0]);
                    if (o == null || o.equals(Object.class)) continue;
                    type = (Class)o;
                    break;
                }
                catch (NoSuchMethodException m) {
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isWarningEnabled()) continue;
                    LOG.warning("There should not be an argument", e);
                }
                catch (Exception e) {
                    if (!LOG.isWarningEnabled()) continue;
                    LOG.warning("", e);
                }
            }
            if (type != null) {
                try {
                    this.constructor = type.getDeclaredConstructor(new Class[0]);
                    this.constructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    if (!this.hasAnnotation(ConstructorArgs.class) && LOG.isWarningEnabled()) {
                        LOG.warning("No usable constructor for " + type.getName(), e);
                    }
                    break block14;
                }
            }
            type = this.getType();
            if (type == List.class || type == Map.class) {
                return null;
            }
            if (type != null) {
                try {
                    this.constructor = type.getDeclaredConstructor(new Class[0]);
                    this.constructor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return this.constructor;
    }

    private void discoverMultivalued() {
        if (this.realType.isArray() || Collection.class.isAssignableFrom(this.realType) || Map.class.isAssignableFrom(this.realType) || GenericArrayType.class.isAssignableFrom(this.genericType.getClass())) {
            this.isSingleValue = false;
            this.isMap = Map.class.isAssignableFrom(this.realType);
            this.isSet = Set.class.isAssignableFrom(this.realType);
            this.isCollection = Collection.class.isAssignableFrom(this.realType);
            this.isArray = this.realType.isArray();
            if (!(this.isMap || this.isSet || this.isCollection || this.isArray)) {
                throw new MappingException(String.format("%s.%s is not a map/set/collection/array : %s", this.field.getName(), this.field.getDeclaringClass(), this.realType));
            }
            Type type = this.realType.isArray() ? this.realType.getComponentType() : (this.subType = ReflectionUtils.getParameterizedType(this.field, this.isMap ? 1 : 0));
            if (this.isMap) {
                this.mapKeyType = ReflectionUtils.getParameterizedType(this.field, 0);
            }
        }
    }

    void setIsMap(boolean isMap) {
        this.isMap = isMap;
    }

    void setIsMongoType(boolean isMongoType) {
        this.isMongoType = isMongoType;
    }

    void setIsSet(boolean isSet) {
        this.isSet = isSet;
    }

    void setMapKeyType(Class mapKeyType) {
        this.mapKeyType = mapKeyType;
    }

    static {
        INTERESTING.add(Serialized.class);
        INTERESTING.add(Indexed.class);
        INTERESTING.add(Property.class);
        INTERESTING.add(Reference.class);
        INTERESTING.add(Embedded.class);
        INTERESTING.add(Id.class);
        INTERESTING.add(Version.class);
        INTERESTING.add(ConstructorArgs.class);
        INTERESTING.add(AlsoLoad.class);
        INTERESTING.add(NotSaved.class);
        INTERESTING.add(Text.class);
    }
}

