/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mongodb.morphia.internal.MorphiaUtils;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.query.ValidationException;

public class PathTarget {
    private final String path;
    private final List<String> segments;
    private boolean validateNames = true;
    private int position;
    private Mapper mapper;
    private MappedClass context;
    private MappedClass root;
    private MappedField target;
    private boolean resolved = false;

    public PathTarget(Mapper mapper, MappedClass root, String path) {
        this.root = root;
        this.segments = Arrays.asList(path.split("\\."));
        this.mapper = mapper;
        this.path = path;
    }

    public void disableValidation() {
        this.resolved = false;
        this.validateNames = false;
    }

    private boolean hasNext() {
        return this.position < this.segments.size();
    }

    public String translatedPath() {
        if (!this.resolved) {
            this.resolve();
        }
        return MorphiaUtils.join(this.segments, '.');
    }

    public MappedField getTarget() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.target;
    }

    String next() {
        return this.segments.get(this.position++);
    }

    private void resolve() {
        this.context = this.root;
        this.position = 0;
        MappedField field = null;
        while (this.hasNext()) {
            String segment = this.next();
            if (segment.equals("$") || segment.matches("[0-9]+")) {
                if (!this.hasNext()) {
                    return;
                }
                segment = this.next();
            }
            if ((field = this.resolveField(segment)) != null) {
                this.translate(field.getNameToStore());
                if (!field.isMap() || !this.hasNext()) continue;
                this.next();
                continue;
            }
            if (!this.validateNames) continue;
            throw new ValidationException(String.format("Could not resolve path '%s' against '%s'.", MorphiaUtils.join(this.segments, '.'), this.root.getClazz().getName()));
        }
        this.target = field;
        this.resolved = true;
    }

    private void translate(String nameToStore) {
        this.segments.set(this.position - 1, nameToStore);
    }

    private MappedField resolveField(String segment) {
        MappedField mf = this.context.getMappedField(segment);
        if (mf == null) {
            mf = this.context.getMappedFieldByJavaField(segment);
        }
        if (mf == null) {
            Iterator<MappedClass> subTypes = this.mapper.getSubTypes(this.context).iterator();
            while (mf == null && subTypes.hasNext()) {
                this.context = subTypes.next();
                mf = this.resolveField(segment);
            }
        }
        if (mf != null) {
            this.context = this.mapper.getMappedClass(mf.getSubClass() != null ? mf.getSubClass() : mf.getConcreteType());
        }
        return mf;
    }

    public String toString() {
        return String.format("PathTarget{root=%s, segments=%s, target=%s}", this.root.getClazz().getSimpleName(), this.segments, this.target);
    }
}

