/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.geo;

import java.util.ArrayList;
import java.util.List;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.geo.Geometry;

@Embedded
@Entity(noClassnameStored=true)
public class Point
implements Geometry {
    private final List<Double> coordinates = new ArrayList<Double>();

    Point(double latitude, double longitude) {
        this.coordinates.add(longitude);
        this.coordinates.add(latitude);
    }

    Point(List<Double> coordinates) {
        this.coordinates.addAll(coordinates);
    }

    public List<Double> getCoordinates() {
        return this.coordinates;
    }

    public double getLatitude() {
        return this.coordinates.get(1);
    }

    public double getLongitude() {
        return this.coordinates.get(0);
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (this.getCoordinates().size() != point.getCoordinates().size()) {
            return false;
        }
        for (int i = 0; i < this.coordinates.size(); ++i) {
            Double coordinate = this.coordinates.get(i);
            if (Double.compare(coordinate, point.getCoordinates().get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("Point{coordinates=%s}", this.coordinates);
    }
}

